/* 
 * File:         selection.h
 * 
 * Description:  header for selection.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#ifndef SELECTION_H
#define SELECTION_H

#include <glib.h>

#include "geo.h"

void sel_vert_select( Vertex *p, int make_undo_entry );
void sel_vert_select_list( GSList *l ) ;
void sel_vert_unselect( Vertex *p, int make_undo_entry );
void sel_vert_unselect_list( GSList *l ) ;
void sel_vert_unselect_all( Model *model );

void sel_vert_hide_selected( Model *model ) ;
void sel_vert_show_all( Model *model ) ;
void sel_vert_show( Vertex *v ) ;

void sel_poly_select( Poly *p, int make_undo_entry ) ;
void sel_poly_select_list( GSList *l ) ;
void sel_poly_unselect( Poly *p, int make_undo_entry ) ;
void sel_poly_unselect_list( GSList *l ) ;
void sel_poly_unselect_all( Model *model );

void sel_poly_hide_selected( Model *model ) ;
void sel_poly_show_all( Model *model ) ;
void sel_poly_show( Poly *p ) ;


#endif
