/* 
 * File:         tex_sgi.h
 * 
 * Description:  header for tex_sgi.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
/*
 * read_sgi_and_convert() - read in an image file in SGI 'libimage' format
 * 	currently its very simple minded and converts all images
 *      to RGBA8 regardless of the input format and returns the
 *	original number of components in the appropriate parameter.
 *    
 *     
 *	the components are converted as follows
 *		L    -> LLL 1.0
 *		LA   -> LLL A
 *		RGB  -> RGB 1.0
 *		RGBA -> RGB A
 *
 * read_image() - read in an image file in SGI 'libimage' format
 *      same as above, but doesn't do any conversion to RGBA8.
 *
 */

#ifndef TEXSGI_H
#define TEXSGI_H

#include <stdio.h>

#include "texture.h"

extern struct texture_file_fmt tex_fmt_sgi;
extern struct texture_file_fmt tex_fmt_rgb;


int sgi_load( FILE *fp, Texture *tex ) ;

unsigned *
read_sgi_and_convert( FILE *fp, int *width, int *height, int *components ) ;
unsigned char *
read_sgi( FILE *fp, int *width, int *height, int *components ) ;

#endif
