/* 
 * File:         texture.h
 * 
 * Description:  header for texture.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef TEXTURE_H
#define TEXTURE_H

#include <stdio.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TEXTURE_NUM_MIP_LEVELS 4

#define TEXTURE_MIP_LEVEL_SMALLEST 0
#define TEXTURE_MIP_LEVEL_MEDIUM   1
#define TEXTURE_MIP_LEVEL_LARGE    2
#define TEXTURE_MIP_LEVEL_OPENGL   3

#define TEXTURE_MIP_LEVEL_SMALLEST_SIZE 32
#define TEXTURE_MIP_LEVEL_MEDIUM_SIZE   128
#define TEXTURE_MIP_LEVEL_LARGE_SIZE    512
#define TEXTURE_MIP_LEVEL_OPENGL_SIZE   TEXTURE_MIP_LEVEL_MEDIUM_SIZE

#define TEXTURE_FORMAT_UNKNOWN	-1

typedef struct _tex Texture;
typedef struct _tex_data tex_data;

struct _tex_data {
    gint width, height;
    gint depth;
    guchar *data;
};

struct _tex {
    char *filename;
    tex_data original;
    tex_data mip[TEXTURE_NUM_MIP_LEVELS];
	GdkPixbuf * pixbuf;
	int upside_down;
};


/* file load abstraction */
struct texture_file_fmt {
  gchar *descr;
  gchar *extension;	/* NULL indicates wildcard */

  gint (* load_tex) (FILE *fp, Texture *tex);
};



Texture *tex_new( void );
void tex_delete( Texture *tt );
Texture * tex_load( const gchar *file_name, int fmt_idx, char *model_fname ) ;
void tex_scale( tex_data *td_src, tex_data *td_dest, int width, int height );

#endif
