/* 
 * File:         toolbar.c
 * 
 * Description:  funcs for creating the toolbar, and handling button-press
 * 		 events, etc...
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

/* allow the old gtk pixmap implementation for now */
#undef GTK_DISABLE_DEPRECATED 


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#include "toolbar.h"
#include "menu.h"
#include "globals.h"
#include "gui.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

/* FILE-SCOPE VARS **********************************************/

#include "pixmaps/new.xpm"
#include "pixmaps/open.xpm"
#include "pixmaps/save.xpm"
#include "pixmaps/vertex_add.xpm"
#include "pixmaps/vertex_move.xpm"
#include "pixmaps/object_rotate.xpm"
#include "pixmaps/object_thin.xpm"
#include "pixmaps/object_scale.xpm"
#include "pixmaps/vertex_sel.xpm"
#include "pixmaps/vertex_sub.xpm"
//#include "pixmaps/tri_add.xpm"
//#include "pixmaps/tri_sel.xpm"
//#include "pixmaps/tri_sub.xpm"
#include "pixmaps/tri_tex.xpm"

#include "pixmaps/zoom.xpm"
#include "pixmaps/pan.xpm"

//#include "pixmaps/exit.xpm"
//#include "pixmaps/lineadd.xpm"
//#include "pixmaps/linesel.xpm"
//#include "pixmaps/linesub.xpm"
//#include "pixmaps/right_arrow.xpm"

GdkPixmap *pixmap_ar[ 12 ];   // poor hack
GdkBitmap *bitmap_ar[ 12 ];
GtkWidget *modal_pixmap[ 4 ];

int default_tool_modes[3 * NUM_TOOL_PALETTES] = {
	CM_OBJECT_SEL,	CM_ZOOM,		CM_PAN,
	CM_OBJECT_SEL,	CM_OBJECT_MOVE,	CM_PAN,
	CM_OBJECT_ADD,	CM_ZOOM,		CM_PAN,
	CM_OBJECT_DEL,	CM_ZOOM,		CM_PAN
};

/* GLOBALS ******************************************************/

int *click_mode = NULL;
int tool_palette_num = 0;
int tool_palettes[NUM_MOUSE_BUTTONS * NUM_TOOL_PALETTES];


/* STRUCTS ******************************************************/

struct toolbar_button_data {
    gchar **pix;
    int clickmode;
    gchar *tooltip;
};

struct toolbar_button_data toolbar_bd[] = {
    { NULL,		-1,			"spacer" },
    
    { vertex_sel_xpm,	CM_OBJECT_SEL,		"Object Select" },
    { vertex_add_xpm,	CM_OBJECT_ADD,		"Object Create" },
    { vertex_sub_xpm,	CM_OBJECT_DEL,		"Object Delete" },
    { vertex_move_xpm,	CM_OBJECT_MOVE,		"Object Move" },
    { object_rotate_xpm,	CM_OBJECT_ROT,		"Object Rotate" },
	{ object_scale_xpm,	CM_OBJECT_SCALE,	"Object Scale" },
	{ object_thin_xpm,	CM_OBJECT_THIN,		"Object Thin/Fatten (Scale Along Normals)" },
/*    { tri_tex_xpm,	CM_OBJECT_TEX,		"Apply Texture to Mesh or Poly" },*/

    { NULL,		-1,			"spacer" },

    { tri_tex_xpm,	CM_OBJECT_EXTRUDE,		"Polygons Extrude" },

    { NULL,		-1,			"spacer" },
    
    { zoom_xpm,		CM_ZOOM,		"Zoom View" },
    { pan_xpm,		CM_PAN,			"Pan View" },

    { NULL, 0, NULL }  /* kinda important... */
};

/* PROTOTYPES ***************************************************/

void tb_quit( GtkWidget *widget, gpointer data ) ;
void toolbar_callback( GtkWidget *widget, GdkEventButton *event, gpointer data ) ;
gboolean tb_palette_switch_cb( GtkWidget *widget, GdkEventScroll *event, 
								gpointer data );

GtkWidget *tb_cm_pixmap_new( char **xpm, GtkWidget *window, int cm ) ;
GtkWidget *tb_pixmap_new( char **xpm, GtkWidget *window ) ;
GtkWidget *tb_create_tool_mode_indicator( void ) ;
void tb_init_tool_palette( void ) ;
void tb_switch_tool_palette( int num ) ;
void tb_change_tool( int button, int newMode ) ;


/* CALLBACKS ****************************************************/

void tb_quit( GtkWidget *widget, gpointer data ) {
    gtk_main_quit();
}

void toolbar_callback( GtkWidget *widget, GdkEventButton *event, gpointer data ) {
	tb_change_tool( event->button, ( int ) data );
}

gboolean tb_palette_switch_cb( GtkWidget *widget, GdkEventScroll *event, 
								gpointer data )
{
	switch( event->direction ) {
		case GDK_SCROLL_UP:
		case GDK_SCROLL_LEFT:
			tb_switch_tool_palette( tool_palette_num - 1 );
			break;
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_RIGHT:
			tb_switch_tool_palette( tool_palette_num + 1 );
			break;
		default:
			/* if the event is not one we are interested in, 
			allow signal to continue to propagate by returning FALSE */
			return FALSE;
	}
	
	return TRUE;
}


/* FUNCS ********************************************************/

GtkWidget *tb_cm_pixmap_new( char **xpm, GtkWidget *window, int cm ) {
    GdkPixmap * gdk_pixmap;
    GdkBitmap * gdk_mask;
    GtkWidget * imageWidget;

    gdk_pixmap = gdk_pixmap_create_from_xpm_d( window->window, &gdk_mask,
                 &window->style->bg[ GTK_STATE_NORMAL ],
                 xpm );
    pixmap_ar[ cm ] = gdk_pixmap;
    bitmap_ar[ cm ] = gdk_mask;

    imageWidget = gtk_image_new_from_pixmap( gdk_pixmap, gdk_mask );
    gtk_widget_show( imageWidget );

    return imageWidget;
}

GtkWidget *tb_pixmap_new( char **xpm, GtkWidget *window ) {
    GdkPixmap * gdk_pixmap;
    GdkBitmap * gdk_mask;
    GtkWidget *imageWidget;

    gdk_pixmap = gdk_pixmap_create_from_xpm_d( window->window, &gdk_mask,
                 &window->style->bg[ GTK_STATE_NORMAL ],
                 xpm );

    imageWidget = gtk_image_new_from_pixmap( gdk_pixmap, gdk_mask );
    gtk_widget_show( imageWidget );

    return imageWidget;
}

GtkWidget *tb_create_tool_mode_indicator( void ) {
    GtkWidget * hbox, *frame;
	GtkWidget *eventbox;
	GtkTooltips *tips;
	int i;
	
	tips = gtk_tooltips_new();

	eventbox = gtk_event_box_new();
    gtk_widget_show( eventbox );
	gtk_tooltips_set_tip( tips, eventbox, 
		"Displays the tool bound to each mouse button", NULL );
	gtk_tooltips_enable( tips );

    frame = gtk_frame_new( NULL );
    gtk_frame_set_shadow_type( GTK_FRAME( frame ), GTK_SHADOW_OUT );
    gtk_widget_show( frame );
    gtk_container_add( GTK_CONTAINER( eventbox ), frame );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_widget_show( hbox );
    gtk_container_add( GTK_CONTAINER( frame ), hbox );
	
	for( i = 1; i < 4; i++ ) {
		modal_pixmap[ i ] = gtk_image_new_from_pixmap( 
			pixmap_ar[ click_mode[ i ] ], bitmap_ar[ click_mode[ i ] ] );
		gtk_widget_show( modal_pixmap[ i ] );
		gtk_box_pack_start( GTK_BOX( hbox ), 
			modal_pixmap[ i ], FALSE, FALSE, 2 );
	}

    return eventbox;
}

void tb_init_tool_palette( void ) {
	int i;
	for( i = 0; i < NUM_TOOL_PALETTES; i++ ) {
		click_mode = tool_palettes + (i * NUM_MOUSE_BUTTONS);
		click_mode[ 1 ] = default_tool_modes[(i*3) + 0];
		click_mode[ 2 ] = default_tool_modes[(i*3) + 1];
		click_mode[ 3 ] = default_tool_modes[(i*3) + 2];
	}

	click_mode = tool_palettes + (tool_palette_num * NUM_MOUSE_BUTTONS);
}

void tb_switch_tool_palette( int num ) {
	int i;
	
	while( num < 0 ) 
		num += NUM_TOOL_PALETTES;
	
	tool_palette_num = num % NUM_TOOL_PALETTES;
	
	click_mode = tool_palettes + (tool_palette_num * NUM_MOUSE_BUTTONS);
	
	for( i = 1; i < 4; i ++ ) {
		tb_change_tool( i, click_mode[ i ] );
	}
}


void tb_change_tool( int button, int newMode ) {
    click_mode[ button ] = newMode;

    gtk_image_set_from_pixmap( GTK_IMAGE( modal_pixmap[ button ] ),
                    pixmap_ar[ newMode ], bitmap_ar[ newMode ] );
}


GtkWidget *create_toolbar( void ) {
    GtkWidget * toolbar, *hbox;
    GtkWidget *pixmap;
    GtkWidget *w;
    int i = 0;

	tb_init_tool_palette();

	toolbar = gtk_toolbar_new();

//    gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), NULL, "Quit", NULL,
//                             tb_pixmap_new( exit_xpm, TopLevelWindow ),
//                             G_CALLBACK( tb_quit ), NULL );
    gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), NULL, "New", NULL,
                             tb_pixmap_new( new_xpm, TopLevelWindow ),
                             G_CALLBACK( menu_new_model ), NULL );
    gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), NULL, "Open", NULL,
                             tb_pixmap_new( open_xpm, TopLevelWindow ),
                             G_CALLBACK( menu_show_load_dialog ), NULL );
    gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), NULL, "Save", NULL,
                             tb_pixmap_new( save_xpm, TopLevelWindow ),
                             G_CALLBACK( menu_show_save_dialog ), NULL );

    for( i = 0; toolbar_bd[i].tooltip != NULL; i++ ) {

        if( toolbar_bd[i].pix == NULL ) {
            gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ) );
        } else {

            pixmap = 
				tb_cm_pixmap_new( 
					toolbar_bd[i].pix, 
					TopLevelWindow, 
					toolbar_bd[i].clickmode );
            w = gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), 
                                         NULL, 
                                         toolbar_bd[i].tooltip, 
                                         NULL, pixmap, NULL, NULL );
            g_signal_connect( G_OBJECT( w ), "button_press_event",
                                G_CALLBACK( toolbar_callback ),
                                ( gpointer )( toolbar_bd[i].clickmode ) );
        }
    }
        

    gtk_widget_show( toolbar );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_box_pack_start( GTK_BOX( hbox ), toolbar, TRUE, TRUE, 0 );
    gtk_box_pack_start( GTK_BOX( hbox ), 
		tb_create_tool_mode_indicator(), FALSE, FALSE, 0 );
    gtk_widget_show( hbox );

	tb_switch_tool_palette( 0 );
	
	/* register the callback for mouse-scroll-wheel tool palette switching */
	g_signal_connect( G_OBJECT( TopLevelWindow ), "scroll-event",
		G_CALLBACK( tb_palette_switch_cb ), NULL );
	

    return hbox;
}


