/* 
 * File:         tools.h
 * 
 * Description:  header for tools.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef TOOLS_H
#define TOOLS_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <glib.h>

#include "vertex.h"
#include "polygon.h"

typedef struct _tools_args ToolsArgs;
struct _tools_args {
    int command;          /* which command is this?  ie select, add, delete, or move? */
    int dragging;         /* is the user dragging something? */
    float start[3];       /* first point */
    float end[3];         /* second point, if there is one */
};

void tools_vertices_move( Model *model, GSList *verts, float deltaX, float deltaY, float deltaZ );
void tools_vertices_snap_to_grid( Model *model, GSList * pts, float spacing );
void tools_vertices_snap_together( Model *model, GSList * plist );
void tools_vertices_snap_together_along_axis( Model *model, GSList * plist, int axis ) ;
void tools_vertices_rotate_90( Model *model, GSList * pts, int axis ) ;
void tools_vertices_rotate( Model *model, GSList * pts, int axis, float angle ) ;
void tools_vertices_rotate_about_point( Model *model, 
	GSList * pts, int axis, float pt[], float angle, 
	int register_with_undo_sys ) ;
void tools_vertices_flip( Model *model, GSList * pts, int axis ) ;
void tools_vertices_scale_about_point( Model *model, 
	GSList * plist, float *factor, float *point, int register_with_undo_sys ) ;
void tools_vertices_scale_about_center( Model *model, 
	GSList * plist, float *factor, int register_with_undo_sys ) ;
void tools_vertices_scale_symmetrically_about_center( Model *model, 
	GSList * plist, float factor, int register_with_undo_sys ) ;
void tools_vertices_scale_about_origin( Model *model, 
	GSList * pts, float factor, int register_with_undo_sys ) ;
void tools_vertices_weld_list( Model *model, GSList *verts ) ;
void tools_vertices_weld( Model *model, Vertex *v1, Vertex *v2 ) ;
void tools_vertices_weld_modelwide( Model *model ) ;

void tools_polys_move( Model *model, GSList *polys, float dX, float dY, float dZ ) ;
void tools_poly_move( Model *model, Poly * p, float dX, float dY, float dZ );
GSList * tools_polys_extrude( Model *model, GSList *polys ) ;
GSList * tools_poly_extrude( Model *model, Poly *p ) ;
GSList * tools_polys_extrude_connected( Model *model, GSList *polys ) ;
void tools_polys_turn_edge( Model *model, GSList *polys ) ;
void tools_polys_make_triangles( Model *model, GSList *plist ) ;
void tools_polys_subdivide_midpoint( Model *model, GSList *plist ) ;
void tools_polys_subdivide_quads( Model *model, GSList *plist ) ;
void tools_polys_subdivide_tris( Model *model, GSList *plist ) ;
void tools_polys_smooth( Model *model, GSList *polys, float factor ) ;
void tools_polys_find_holes( Model *model, GSList *polys ) ;

void tools_scale_along_normals( Model *model, GSList *polys, GSList *verts, float factor ) ;

#endif
