/* 
 * File:         undo.h
 * 
 * Description:  header for undo.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef UNDO_H
#define UNDO_H

#include <glib.h>

#include "geo.h"
#include "model.h"

/*
							objects			object	mesh	fargs		iargs	misc
ACTION_VERTEX_SEL			list			-		-		-			-		-
ACTION_VERTEX_UNSEL			list			-		-		-			-		-
ACTION_VERTEX_MOVE			list, NULL==sel	-		-		delta[3]	-		-
ACTION_VERTEX_ROT			list, NULL==sel	-		-		0,0,0,angle	axis	-
ACTION_VERTEX_SCALE			list, NULL==sel	-		-		factor[3],center[3]	-		-
ACTION_VERTEX_ADD_TO_MODEL	-				vert	-		-			-		-
ACTION_VERTEX_REMOVE_MODEL	-				vert	-		-			-		-
ACTION_VERTEX_ADD_TO_MESH	-				vert	mesh	-			-		-
ACTION_VERTEX_REMOVE_MESH	-				vert	mesh	-			-		-
ACTION_VERTEX_ADD_TO_POLY	-				vert	-		-			-		poly
ACTION_VERTEX_REMOVE_POLY	-				vert	-		-			v_idx	poly
ACTION_VERTEX_SWITCH_POLY	-				vert	-		-			v_idx	poly

ACTION_POLY_SEL				list			-		-		-			-		-
ACTION_POLY_UNSEL			list			-		-		-			-		-
ACTION_POLY_ADD_TO_MESH		-				poly	mesh	-			-		-
ACTION_POLY_REMOVE_MESH		-				poly	mesh	-			-		-
ACTION_POLY_REVERSE_WINDING	-				poly	-		-			-		-
*/

typedef enum {
	ACTION_UNKNOWN,

	ACTION_VERTEX_SEL,
	ACTION_VERTEX_UNSEL,
	ACTION_VERTEX_MOVE,
	ACTION_VERTEX_ROT,
	ACTION_VERTEX_SCALE,
	ACTION_VERTEX_ADD_TO_MODEL,
	ACTION_VERTEX_REMOVE_MODEL,
	ACTION_VERTEX_ADD_TO_MESH,
	ACTION_VERTEX_REMOVE_MESH,
	ACTION_VERTEX_ADD_TO_POLY,
	ACTION_VERTEX_REMOVE_POLY,
	ACTION_VERTEX_SWITCH_POLY,
	
	ACTION_POLY_SEL,
	ACTION_POLY_UNSEL,
	ACTION_POLY_ADD_TO_MESH,
	ACTION_POLY_REMOVE_MESH,
	ACTION_POLY_REVERSE_WINDING,

	ACTION_MESH_ADD,
	ACTION_MESH_DEL,
	ACTION_MESH_EDIT,
		
	ACTION_MAX,  /* don't add anything below here */
	ACTION_MARKER /* denotes the end-of-input */
} ActionType;


typedef struct _Action Action;
struct _Action {
ActionType type;

GSList *objects;
void *object;
Mesh *mesh;

float *fargs;
int *iargs;

void *misc;
};


void undo_init( void ) ;

void undo_enable( Model *model ) ;
void undo_disable( Model *model ) ;
void action_clear_stack( Model *model ) ;
void action_do( Model *model, ActionType type, GSList *objects, void *object, 
				Mesh *mesh, float *fargs, int *iargs, void *misc );
void action_undo( Model *model );

#endif
