/* 
 * File:         vector.h
 * 
 * Description:  header for vector stuff
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
/* this makes life easier for doing 3d transforms. */

#ifndef VECTOR_H
#define VECTOR_H

#ifdef __cplusplus
extern "C" {
#endif
  
//#include <GL/gl.h>
//#include <GL/glu.h>

void vector_zero( float *v1 ) ;
void vector_copy( float *v1, float *v2 ) ;
void vector_add( float *v1, float *v2, float *v3 ) ;
void vector_sub( float *v1, float *v2, float *v3 ) ;
float vector_length( float *v1 ) ;
float vector_length_sqrd( float *v1 ) ;
float vector_normalize( float *v1 ) ;
void vector_cross_prod( float *v1, float *v2, float *v3 ) ;
float vector_dot_prod( float *v1, float *v2 ) ;
void vector_mul( float *v1, float *v2, float s ) ;
void vector_mul_piecewise( float *v1, float *v2, float *v3 ) ;
void vector_find_point( float *v1, float *v2, float *v3, float s ) ;
float vector_find_dist_pt2line( float *rayorig, float *raydir, float *pt ) ;
float vector_find_heading( float *v );
float vector_dist( float *v1, float *v2 ) ;
float vector_dist_sqrd( float *v1, float *v2 ) ;
int vector_coincident( float *v1, float *v2 ) ;
void vector_rotate_about_point( 
	float *result, float *v, int axis, float *origin, float angle ) ;

#ifdef __cplusplus
}
#endif

#endif

