/* 
 * File:         vertex.h
 * 
 * Description:  header for vertex.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef VERTEX_H
#define VERTEX_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <glib.h>

#include "geo.h"
#include "mesh.h"
#include "globals.h"

#define POINTS_FUDGE_FACTOR  0.005  /* half a centimeter of leeway */


Vertex* vertex_new( void );
void vertex_delete( Vertex *v ) ;
void vertex_remove( Vertex *v ) ;
Vertex* vertex_dup( Vertex* p );

/* called only by poly.c */
void vertex_add_poly( Vertex *v, Poly *p ) ;
/* called only by poly.c */
void vertex_remove_poly( Vertex *v, Poly *p ) ;
int vertex_has_poly( Vertex *v, Poly *p ) ;
int vertex_is_in_use( Vertex *v );

void vertex_move( Vertex *v, float deltaX, float deltaY, float deltaZ ) ;

void vertices_find_mean( GSList * plist, Vertex* average ) ;
float vertices_find_angle( Vertex *c, Vertex *v1, Vertex *v2 );

gint vertices_isIdentical( Vertex* p1, Vertex* p2 ) ;
gint vertices_isEqual( Vertex* p1, Vertex* p2 ) ;
gint vertices_isNotEqual( Vertex* p1, Vertex* p2 ) ;

GSList * verts_get_polys_unique( GSList *verts ) ;
GSList * verts_get_polys( GSList *verts ) ;

#endif
