/* 
 * File:         view.h
 * 
 * Description:  header for view.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#ifndef VIEW_H
#define VIEW_H

#include <gtk/gtk.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <gtk/gtkgl.h>

#include "geo.h"


typedef enum {
    VIEW_XY,
    VIEW_YZ,
    VIEW_XZ,
    VIEW_3D
} ViewNums;


typedef struct _model_view model_view;

struct _model_view {

    GtkWidget *gltable;
    GtkWidget *glarea;
    
	GdkGLContext *glcontext;
	GdkGLDrawable *gldrawable;

    GLfloat grid_mins[ 3 ];
    GLfloat grid_maxes[ 3 ];

    GLfloat heading, pitch, roll; 		  /* viewport orientation */
    GLfloat dist;
    GLfloat camX, camY, camZ; 	                  /* Camera location. */
    GLfloat minX, minY, minZ, maxX, maxY, maxZ;   /* used to set up orthographic views */
    
    GLfloat cursX, cursY, cursZ, cursA;

    int type;
    int dirty;
	int flipped;
};



extern model_view *views[4];


GtkWidget *create_view( int type );
GtkWidget *view_create_dummy_drawable( void ) ;

gboolean view_redraw_all( void ) ;
void view_redraw_n( int frame_num ) ;

gint view_flip_cb( GtkWidget *widget, gpointer data ) ;

void view_set_height( float height ); /* acts on the 3d view only */
void view_fov_changed( void ); /* acts on the 3d view only */

#endif






