/* 
 * File:         view_config.h
 * 
 * Description:  header for view_config.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#ifndef VIEW_CONFIG_H
#define VIEW_CONFIG_H

#include <GL/gl.h>
#include <GL/glu.h>


#define MP_SHOW_WIREFRAME  0
#define MP_SHOW_FLAT	   1
#define MP_SHOW_TEXTURED   2

#define MP_MODE_RENDER		  0
#define MP_MODE_SELECTION	   1

#define MP_TRI_ORDER_CCW  0
#define MP_TRI_ORDER_CW   1
#define MP_TRI_ORDER_ALL  2

typedef struct _model_view_config model_view_config;

/* view configuration */
struct _model_view_config {

	GLfloat bkgnd_color[ 3 ];
	GLfloat grid_color[ 3 ];
	GLfloat vertex_unsel_color[ 3 ];
	GLfloat vertex_sel_color[ 3 ];
	GLfloat poly_unsel_color[ 3 ];
	GLfloat poly_sel_color[ 3 ];


	GLfloat cursor_rad;
	GLfloat vertex_rad;
	GLfloat girder_rad;

	GLfloat fov, near_plane, far_plane;

	GLfloat grid_spacing;

	unsigned int vertices_visible;
	unsigned int grid_visible;
	unsigned int origin_visible;
	unsigned int normals_visible;
	
	unsigned int cursor_visible;

	int polygon_mode;	/* textured, flat, wireframe, etc. */
	int render_mode;	/* regular rendering, or picking */
	int triangle_order;	/* counter-clockwise, clockwise, etc */
	
	int draw_verts_as_cubes;
};

extern model_view_config view_config;

extern GLfloat *cursor_glarray;		/* GL arrays describing */
extern GLfloat *vertex_glarray; 	/* helper objects */
extern GLfloat *girder_glarray;


void view_config_init( void ) ;
int view_retrieve_preferences( void ) ;

void view_rebuild_glarrays( void ) ;

void view_set_rendermode( int mode );
void view_set_triangleorder( int order );
void view_set_vertexsize( float size );
void view_set_fov( float fov );

#endif



