/***************************************************************************
                editeventsdialog.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 22:20:01 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editeventsdialog.h"
#include "listboxevent.h"
#include <config.h>
#include <qsize.h>
#include <qcursor.h>
#include <kmessagebox.h>

EditEventsDialog::EditEventsDialog(KLuJe *parent, const char *name, bool modal) :
  KDialogBase(Plain, QString("Edit events"), Apply|Ok|Cancel, Ok,
  (QWidget *) parent, name, modal, true)
{
  activeEvent = NULL;
  page = plainPage();
  eventsTable = new QDict<char>(17, FALSE);
  topLayout = new QHBoxLayout(page, 0, spacingHint(), "topLayout");

  // LEFT side of dialog
  navigator = new QVBox(page, "navigator");
  datePicker = new KDatePicker(navigator);
  eventPicker = new KListBox(navigator);

  // RIGHT side of dialog
  editor = new QVBox(page, "editor");
  dateEditor = new QDateTimeEdit(editor);
  subjEditor = new QHBox(editor, "subjEditor");
  subjLineLabel = new QLabel("Subject:", subjEditor);
  subjLineEdit = new KLineEdit(subjEditor);
  eventEdit = new KEdit(editor);
  eventEdit->setWordWrap(QMultiLineEdit::WidgetWidth);
  editor->setDisabled(TRUE);
  
  // Put it all together
  topLayout->addWidget(navigator, 0);
  topLayout->addWidget(editor, 1);
  kapp->config()->setGroup("EventEditor");
  int width = kapp->config()->readNumEntry("Width", 640);
  int height = kapp->config()->readNumEntry("Height", 480);
  setInitialSize(configDialogSize("EventEditor"));

  // When a date is clicked, download that day's events and display the 
  // subjects in a list box.
  connect(datePicker, SIGNAL(dateSelected(QDate)), 
    ((KLuJe *) this->parent())->getIO(), SLOT(slotGetevents(QDate)));
  connect(datePicker, SIGNAL(dateSelected(QDate)),
    this, SLOT(slotClearEditor()));
  connect(datePicker, SIGNAL(dateEntered(QDate)), 
    ((KLuJe *) this->parent())->getIO(), SLOT(slotGetevents(QDate)));
  connect(datePicker, SIGNAL(dateEntered(QDate)),
    this, SLOT(slotClearEditor()));
  connect(((KLuJe *)this->parent())->getIO(), SIGNAL(newEvents(QPtrList<LJEvent>*)),
    this, SLOT(slotUpdateEvents(QPtrList<LJEvent>*)));
  
  // When a subject is clicked, redraw the "editor" (RIGHT) side of the dialog
  connect(eventPicker, SIGNAL(executed(QListBoxItem*)), this, 
    SLOT(slotEventPicked(QListBoxItem*)));
}

void EditEventsDialog::slotShowDialog()
{
  show();
  ((KLuJe*) this->parent())->getIO()->slotGetevents(QDate::currentDate());
}

void EditEventsDialog::slotEventPicked(QListBoxItem *item) {
  if (shouldSave()) slotApply();
  kdDebug(6969) << "EditEventsDialog::slotEventPicked -- got " << item->text() << endl;
  LJEvent* event = ((ListBoxEvent*)item)->getEvent();
  subjLineEdit->setText(event->getSubject());
  eventEdit->setText(event->getText());
  dateEditor->setDateTime(QDateTime(event->getDate(), event->getTime()));
  kdDebug(6969) << "EditEventsDialog::slotEventPicked -- when: " << dateEditor->dateTime().toString() << endl;
  activeEvent = event;
  kdDebug(6969) << "EditEventsDialog::slotEventPicked -- eventid " << QString::number(event->getId()) << endl;
  editor->setEnabled(TRUE);
}

void EditEventsDialog::slotUpdateEvents(QPtrList<LJEvent> *events) {
  eventPicker->clear();
  QPtrListIterator<LJEvent> it(*events);
  while (it.current())
  {
    kdDebug(6969) << "EditEventsDialog::slotUpdateEvents -- adding item." << endl;
    ListBoxEvent *event;
    if (it.current()->getSubject() != "")
      event = new ListBoxEvent(it.current()->getSubject());
    else
      event = new ListBoxEvent(it.current()->getText());
    event->setEvent(it.current());
    eventPicker->insertItem(event);
    ++it;
  }
  navigator->setEnabled(TRUE);
}

void EditEventsDialog::slotClearEditor()
{
  if (shouldSave()) slotApply();
  //this->disable();
  navigator->setDisabled(TRUE);
  editor->setDisabled(TRUE);
  eventPicker->clear();
  subjLineEdit->clear();
  eventEdit->clear();
  dateEditor->setDateTime(QDateTime::fromString("1970-01-01 00:00:00", Qt::ISODate));
}

bool EditEventsDialog::shouldSave()
{
  if(activeEvent == NULL) return false;
  bool dirty = false;
  if (eventEdit->text() != activeEvent->getText()) dirty = true;
  if (subjLineEdit->text() != activeEvent->getSubject()) dirty = true;
  if (dirty == true)
  {
    int response = KMessageBox::questionYesNo(this, 
      "Changes have been made. Do you want to save them?", "Save changes?");
    if (response == KMessageBox::Yes) return true;
  }
  activeEvent = NULL;
  return false;
}

void EditEventsDialog::slotApply()
{
  //editor->setDisabled(TRUE);
  activeEvent->setText(eventEdit->text());
  activeEvent->setSubject(subjLineEdit->text());
  activeEvent->setDate(dateEditor->dateTime().date());
  activeEvent->setTime(dateEditor->dateTime().time());
  ((KLuJe *) this->parent())->getIO()->slotSaveEvent(*activeEvent);
  //editor->setEnabled(TRUE);
}

void EditEventsDialog::slotOk()
{
  slotApply();
  accept();
}

void EditEventsDialog::disable()
{
  this->setEnabled(false);
  this->setCursor(QCursor(Qt::WaitCursor));
  subjLineEdit->setCursor(QCursor(Qt::WaitCursor));
  eventEdit->setCursor(QCursor(Qt::WaitCursor));
}

void EditEventsDialog::enable()
{
  this->setEnabled(true);
  this->setCursor(QCursor(Qt::ArrowCursor));
  subjLineEdit->setCursor(QCursor(Qt::ArrowCursor));
  eventEdit->setCursor(QCursor(Qt::ArrowCursor));
}

EditEventsDialog::~EditEventsDialog()
{
  kapp->config()->setGroup("EventEditor");
  saveDialogSize("EventEditor");
}
