/***************************************************************************
                  editeventsdialog.h  -  description
                             -------------------
    begin                : Sun Feb 24 22:20:01 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITEVENTSDIALOG_H
#define EDITEVENTSDIALOG_H

#include "kluje.h"
 
#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kpassdlg.h>
#include <kconfig.h>
#include <kdatepik.h>
#include <kdatewidget.h>
#include <qdatetimeedit.h>
#include <klistbox.h>
#include <klineedit.h>
#include <keditcl.h>
#include <qlabel.h>
#include <iostream.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qdict.h>
#include <kdebug.h>
#include <iostream.h>
#include <qptrlist.h>
#include <qdialog.h>

class EditEventsDialog : public KDialogBase {
  Q_OBJECT

  public:
    EditEventsDialog(KLuJe *parent, const char *name=0, bool modal=false);
    KListBox* eventList() { return eventPicker; }
    QDict<char>* events() { return eventsTable; }
    ~EditEventsDialog(void);

  public slots:
    virtual void slotShowDialog();
    virtual void slotEventPicked(QListBoxItem *item);
    virtual void slotUpdateEvents(QPtrList<LJEvent> *events);

  private:
    QDict<char> *eventsTable;
    QFrame *page;
    QHBoxLayout *topLayout;
    QVBox *navigator;
    QVBox *editor;
    QHBox *subjEditor;
    QDateTimeEdit *dateEditor;
    KDatePicker *datePicker;
    KListBox *eventPicker;
    KLineEdit *subjLineEdit;
    QLabel *subjLineLabel;
    KEdit *eventEdit;
    LJEvent *activeEvent;
    void disable();
    void enable();
    bool shouldSave();

  protected slots:
    void slotApply();
    void slotOk();
    void slotClearEditor();
};

#endif
