/***************************************************************************
              kluje.cpp  -  description
               -------------------
  begin                : Mon Jan 28 22:22:24 EST 2002
  copyright            : (C) 2002 by Buddy Brewer
  email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kluje.h"
#include "klujeio.h"
#include "klujesystray.h"
#include <qvbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <kcombobox.h>
#include <kcompletion.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>
#include <keditcl.h>
#include <klineedit.h>
#include <qpushbutton.h>
#include <qmultilineedit.h>
#include <kspell.h>
#include <kwin.h>
#include <kstdaction.h>
#include <khelpmenu.h>
#include <kurl.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>

KLuJe::KLuJe(const char *name) : KMainWindow(0, name), 
  interval(90)
{
  // Initialize the preferences dialog, display Preferences dialog if neccesary
  prefsDialog = new PreferencesDialog(kapp->config());
  kapp->config()->setGroup("ServerInfo");
  if(kapp->config()->readEntry("Username", "") == "") {
    prefsDialog->exec();
  }

  // read in config info
  kapp->config()->setGroup("ServerInfo");
  user = kapp->config()->readEntry("Username", "");
  QString password = kapp->config()->readEntry("Password", "");
  QString serverUrl = kapp->config()->readEntry("ServerUrl", 
    "http://www.livejournal.com/cgi-bin/log.cgi");
  klujeIO = new KLuJeIO(this, user, password, serverUrl);
  kapp->config()->setGroup("MainWindow");

  // set up the main gui stuff
  setMinimumWidth(kapp->config()->readNumEntry("Width", 640));
  setMinimumHeight(kapp->config()->readNumEntry("Height", 480));
  setCaption("KLuJe");
  kapp->setTopWidget(this);
  KWin::setIcons(winId(), DesktopIcon("kluje"), SmallIcon("kluje"));
  this->setIcon(SmallIcon("kluje"));
  moods = new KLuJeMoods(kapp->config());

  connect(prefsDialog, SIGNAL(configChanged(const KConfig &)), 
    klujeIO, SLOT(slotConfigChanged(const KConfig &)));

  // Initialize the editevents dialog
  editEventsDialog = new EditEventsDialog(this);

  // Used for polling checkfriends info
  lastUpdate = QString("");
  timer = new QTimer( this );
  connect( timer, SIGNAL(timeout()), klujeIO, SLOT(slotCheckFriends()) );

  // Manually call checkfriends once to initialize polling intervals
  // and last checked time
  klujeIO->slotCheckFriends();

  sysTray = new KLuJeSysTray(this);

  // set up statusbar
  statusBar()->message("Status: Ready!");

  // set up main view
  kapp->config()->setGroup("MainWindow");
  QVBox *box = new QVBox(this);
  subjEditor = new QHBox(box);
  subjectLabel = new QLabel("Subject:", subjEditor);
  subjLineEdit = new KLineEdit(subjEditor);
  if (kapp->config()->readBoolEntry("showSubjectEditor", true) == false)
    subjEditor->hide();

  text = new KEdit(box);
  text->setWordWrap(QMultiLineEdit::WidgetWidth);

  moodEditor = new QHBox(box);
  moodLabel = new QLabel("Mood:", moodEditor);
  moodCombo = new KComboBox(true, moodEditor);
  moodEditor->setStretchFactor(moodCombo, 2);
  if (kapp->config()->readBoolEntry("showMoodEditor", true) == false)
    moodEditor->hide();

  songEditor = new QHBox(box);
  songLabel = new QLabel("Music:", songEditor);
  songLineEdit = new KLineEdit(songEditor);
  if (kapp->config()->readBoolEntry("showMusicEditor", true) == false)
    songEditor->hide();

  journalEditor = new QHBox(box);
  journalLabel = new QLabel("Journal:", journalEditor);
  journalCombo = new KComboBox(false, journalEditor);
  journalEditor->setStretchFactor(journalCombo, 2);
  if (kapp->config()->readBoolEntry("showJournalEditor", true) == false)
    journalEditor->hide();

  securityEditor = new QHBox(box);
  securityLabel = new QLabel("Security:", securityEditor);
  securityCombo = new KComboBox(false, securityEditor);
  securityCombo->insertItem("Public");
  securityCombo->insertItem("Private");
  securityCombo->insertItem("Friends only");
  securityEditor->setStretchFactor(securityCombo, 2);
  if (kapp->config()->readBoolEntry("showSecurityEditor", true) == false)
    securityEditor->hide();

  setCentralWidget(box);
  
  // Init animation variables
  inverted = false;
  animating = false;

  // Animation signals
  connect(klujeIO, SIGNAL(checkfriendsNotify()), this, SLOT(slotStartAnimation()));
  connect(sysTray, SIGNAL(userClicked()), this, SLOT(slotStopAnimation()));

  // Log in to LJ server, get moods, etc.
  klujeIO->slotLogin();
  setupActions();

  kapp->config()->setGroup("MainWindow");
  if (kapp->config()->readBoolEntry("showMenuBar", true) == false)
    menuBar()->hide();
  if (kapp->config()->readBoolEntry("showToolBar", true) == false)
    toolBar()->hide();
  if (kapp->config()->readBoolEntry("showStatusBar", true) == false)
    statusBar()->hide();
}

void KLuJe::setupActions()
{
  // File menu
  (void)new KAction("&Login", QIconSet(BarIcon ("connect_creating")),
    CTRL+Key_L, klujeIO, SLOT(slotLogin()), actionCollection(), "login");
  (void)new KAction("&Submit entry", QIconSet(BarIcon ("forward")),
    CTRL+Key_S, klujeIO, SLOT(slotPostevent()), actionCollection(), "submit_entry");
  (void)new KAction("&Clear", QIconSet(BarIcon("eraser")),
    CTRL+Key_I, this, SLOT(slotClear()), actionCollection(), "clear");
  (void)new KAction("&Quit", KStdAccel::quit(), 
    kapp, SLOT(closeAllWindows()), actionCollection(), "quit");

  // Edit menu
  kapp->config()->setGroup("MainWindow");
  KStdAction::cut(this, SLOT(slotCut()), actionCollection());
  KStdAction::copy(this, SLOT(slotCopy()), actionCollection());
  KStdAction::paste(this, SLOT(slotPaste()), actionCollection());
  (void)new KAction("&Spell Check", QIconSet(BarIcon ("spellcheck")),
    CTRL+Key_P, this, SLOT(slotSpellCheck()), actionCollection(), "spellcheck");
  (void)new KAction("&Preferences...", QIconSet(BarIcon("configure")),
    0, prefsDialog, SLOT(show()), actionCollection(), "show_preferences");
  (void)new KAction("&Edit posts", QIconSet(BarIcon("edit")),
    0, editEventsDialog, SLOT(slotShowDialog()), actionCollection(), "show_editevents");


  // Settings menu
  KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection())
    ->setChecked(kapp->config()->readBoolEntry("showToolBar", true));
  KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection())
    ->setChecked(kapp->config()->readBoolEntry("showStatusBar", true));
  KStdAction::showMenubar(this, SLOT(slotViewMenuBar()), actionCollection())
    ->setChecked(kapp->config()->readBoolEntry("showMenuBar", true));
  KToggleAction* journaledit = new KToggleAction("Show journal editor", 0, this,
    SLOT(slotViewJournalEdit()), actionCollection(), "show_journaledit");
  journaledit->setChecked(kapp->config()->readBoolEntry("showJournalEditor", true));
  KToggleAction* musicedit = new KToggleAction("Show music editor", 0, this,
    SLOT(slotViewSongEdit()), actionCollection(), "show_musicedit");
  musicedit->setChecked(kapp->config()->readBoolEntry("showMusicEditor", true));
  KToggleAction* subjectedit = new KToggleAction("Show subject editor", 0, this,
    SLOT(slotViewSubjectEdit()), actionCollection(), "show_subjectedit");
  subjectedit->setChecked(kapp->config()->readBoolEntry("showSubjectEditor", true));
  KToggleAction* moodedit = new KToggleAction("Show mood editor", 0, this,
    SLOT(slotViewMoodEdit()), actionCollection(), "show_moodedit");
  moodedit->setChecked(kapp->config()->readBoolEntry("showMoodEditor", true));

  kdDebug(6969) << "setupActions: calling createGUI" << endl;
  createGUI();
}

void KLuJe::slotCut()
{
  if (subjLineEdit->hasFocus()) subjLineEdit->cut();
  if (text->hasFocus()) text->cut();
  if (moodCombo->hasFocus()) moodCombo->lineEdit()->cut();
  if (songLineEdit->hasFocus()) songLineEdit->cut();
}

void KLuJe::slotCopy()
{
  if (subjLineEdit->hasFocus()) subjLineEdit->copy();
  if (text->hasFocus()) text->copy();
  if (moodCombo->hasFocus()) moodCombo->lineEdit()->copy();
  if (songLineEdit->hasFocus()) songLineEdit->copy();
}

void KLuJe::slotPaste()
{
  if (subjLineEdit->hasFocus()) subjLineEdit->paste();
  if (text->hasFocus()) text->paste();
  if (moodCombo->hasFocus()) moodCombo->lineEdit()->paste();
  if (songLineEdit->hasFocus()) songLineEdit->paste();
}

void KLuJe::slotClear()
{
  text->clear();
  subjLineEdit->clear();
  moodCombo->setEditText("");
  songLineEdit->clear();
  journalCombo->setCurrentItem(0);
  securityCombo->setCurrentItem(0);
}

void KLuJe::slotSpellCheck()
{
  kdDebug(6969) << "KLuJe::slotSpellCheck() called" << endl;
  QString oldText = text->text();
  KSpell::modalCheck(oldText);
  text->setText(oldText);
}

void KLuJe::slotViewToolBar()
{
  toggleWidget(toolBar(), "showToolBar");
}

void KLuJe::slotViewStatusBar()
{
  toggleWidget(statusBar(), "showStatusBar");
}

void KLuJe::slotViewMenuBar()
{
  toggleWidget(menuBar(), "showMenuBar");
}

void KLuJe::slotViewJournalEdit()
{
  toggleWidget(journalEditor, "showJournalEditor");
}

void KLuJe::slotViewSongEdit()
{
  toggleWidget(songEditor, "showMusicEditor");
}

void KLuJe::slotViewMoodEdit()
{
  toggleWidget(moodEditor, "showMoodEditor");
}

void KLuJe::slotViewSubjectEdit()
{
  toggleWidget(subjEditor, "showSubjectEditor");
}

void KLuJe::toggleWidget(QWidget* widget, QString key)
{
  kapp->config()->setGroup("MainWindow");
  if (widget->isVisible())
  {
    kapp->config()->writeEntry(key, false);
    widget->hide();
  }
  else
  {
    kapp->config()->writeEntry(key, true);
    widget->show();
  }
}

void KLuJe::slotStopAnimation()
{
  kdDebug(6969) << "Called stop animate" << endl;
  animating = false;
}

void KLuJe::slotStartAnimation() 
{
  animating = true;
  kdDebug(6969) << "Called start animate" << endl;
  slotAnimate();
}

void KLuJe::slotAnimate()
{
  kdDebug(6969) << "Animating" << endl;

  // Swap the icons and check again in half a second as long
  // as the user has not signalled
  // to stop animation by clicking on the system tray
  if( animating )
  {
    kdDebug(6969) << "Animating icon" << endl;
    switchIcon();
    QTimer::singleShot( 500, this, SLOT(slotAnimate()));
  } else
  {
    // Animation is over, so start polling again
    kdDebug(6969) << "User interrupted animation, poll" << endl;
    this->lastUpdate = QString("");
    this->enablePolling();
    
    // if Icon is inverted, switch back to the normal icon
    // since animation is done
    if(inverted) switchIcon();
  }
}

void KLuJe::switchIcon()
{
  QString newIcon = inverted ? QString("kluje") : QString("kluje_blink");
  KWin::setIcons(this->winId(), SmallIcon( newIcon ), SmallIcon( newIcon ));
  sysTray->setPixmap(SmallIcon( newIcon ));
  inverted = !inverted;
}

void KLuJe::slotExit()
{
  kdDebug(6969) << "Exit called" << endl;
  this->close();
}

bool KLuJe::usesPayServer()
{
  kapp->config()->setGroup("ServerInfo");
  return kapp->config()->readBoolEntry("FastServer", false);
}

void KLuJe::setUsePayServer(bool paid)
{
  kapp->config()->setGroup("ServerInfo");
  kapp->config()->writeEntry("FastServer", paid);
}

KLuJe::~KLuJe()
{
  kapp->config()->setGroup("MainWindow");
  kapp->config()->writeEntry("Width", width());
  kapp->config()->writeEntry("Height", height());
}
