/***************************************************************************
                          kluje.h  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLUJE_H
#define KLUJE_H

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include "klujeio.h"
#include "klujemoods.h"
#include "klujesystray.h"
#include "preferencesdialog.h"
#include "editeventsdialog.h"
#include <kstatusbar.h>
#include <kmainwindow.h>
#include <kapp.h>
#include <kaction.h>
#include <qdict.h>
#include <qstring.h>
#include <qtimer.h>

class QLabel;
class KEdit;
class KLineEdit;
class QPushButton;
class KComboBox;
class KActionCollection;
class SongQuery;

/** 
 * KLuJe is the base class, providing app initialization 
 * services, session restoration, and window management.
 * The class extends KMainWindow and manages the UI
 * elements.
 *
 * At construction time, an instance of the @ref KLuJeIO
 * class is created.  KLuJe delegates all client server
 * actions to the KLuJeIO object. 
 */
class KLuJe : public KMainWindow {
  Q_OBJECT 

public:
  /** construtor */
  KLuJe(const char *name=0);
  /** destructor */
  ~KLuJe();
  KComboBox* getMoodCombo() { return moodCombo; }
  KComboBox* getSecurityCombo() { return securityCombo; }
  KLineEdit* getSubjectLineEdit() { return subjLineEdit; }
  KLineEdit* getSongLineEdit() { return songLineEdit; }
  KComboBox* getJournalCombo() { return journalCombo; }
  KEdit* getText() { return text; }
  QString getUserName() { return user; }
  QString getLastUpdate() { return lastUpdate; }
  void setLastUpdate(QString newUpdate) { lastUpdate = newUpdate; }
  KLuJeSysTray * getSysTray() { return sysTray; }
  KLuJeMoods * getMoods() { return moods; }
  EditEventsDialog * getEditEvents() { return editEventsDialog; }
  PreferencesDialog * getPrefs() { return prefsDialog; }
  KLuJeIO * getIO() { return klujeIO; }
  void setInterval(int newInterval) { interval = newInterval; }
  void enablePolling() { timer->start(interval * 1000, TRUE); }
  void setUsePayServer(bool);
  bool usesPayServer();
  void login() { klujeIO->slotLogin(); }

public slots:
  void slotCut();
  void slotCopy();
  void slotPaste();
  void slotClear();
  void slotSpellCheck();
  void slotViewMenuBar();
  void slotViewToolBar();
  void slotViewStatusBar();
  void slotViewSongEdit();
  void slotViewJournalEdit();
  void slotViewMoodEdit();
  void slotViewSubjectEdit();
  void slotExit();
  // For animating checkfriends notification
  void slotAnimate();
  void slotStartAnimation();
  void slotStopAnimation();

private:
  void setupActions();
  // Switches between the normal icon and the kluje_blink
  // icon
  void switchIcon();
  // used for polling checkfriends information
  int interval;
  QString lastUpdate;
  QTimer *timer;
  // UI stuff
  KEdit *text;
  KLineEdit *subjLineEdit;
  QLabel *subjectLabel;
  QLabel *moodLabel;
  QLabel *songLabel;
  QLabel *securityLabel;
  QHBox *songEditor;
  QHBox *journalEditor;
  QHBox *subjEditor;
  QHBox *moodEditor;
  QHBox *securityEditor;
  QLabel *journalLabel;
  KLineEdit *songLineEdit;
  KComboBox *journalCombo;
  KComboBox *moodCombo;
  KComboBox *securityCombo;
  PreferencesDialog *prefsDialog;
  EditEventsDialog *editEventsDialog;
  KLuJeIO * klujeIO;
  KLuJeSysTray * sysTray;
  KLuJeMoods * moods; // Storage for moods
  QString user; // user for checkfriends animation
  bool animating; 
  bool inverted;
  void toggleWidget(QWidget* widget, QString key);
};

#endif
