/***************************************************************************
                            kluje.cpp  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kluje.h"
#include "editeventsdialog.h"
#include "klujeio.h"

// Needed for encoding strings
#include <kurl.h>

// debug includes
#include <kdebug.h>
#include <iostream.h>

// Used for parsing server resposnes
#include <qasciidict.h>
#include <qregexp.h>

#include <keditcl.h>
#include <kcombobox.h>
#include <klineedit.h>

#include <qstrlist.h>

#include <kmessagebox.h>

KLuJeIO::KLuJeIO(KLuJe *kluje, QString user, QString pass, QString server)
: QObject(),
klujeWin(kluje), 
username(user),
password(pass),
serverUrl(server),
response_counter(0)
{
}

void
KLuJeIO::slotPostevent()
{
  kdDebug(6969) << "KLuJeIO::slotPostevent called" << endl;

  // TODO: prop_opt_preformatted=0, prop_picture_keyword=blah
  QDateTime now = QDateTime::currentDateTime();
  QDate date = now.date();
  QTime time = now.time();
  // figure out if there's a mood and construct the appropriate request fragment
  // construct the complete request string
  QString postdata = "mode=postevent&user=" + KURL::encode_string(username) +
    "&hpassword=" + KURL::encode_string(password) + "&event=" +
    KURL::encode_string(klujeWin->getText()->text()) + "&subject=" +
    KURL::encode_string(klujeWin->getSubjectLineEdit()->text()) + "&year=" +
    QString::number(date.year()) + "&mon=" + QString::number(date.month()) +
    "&day=" + QString::number(date.day()) +
    "&min=" + QString::number(time.minute()) + 
    "&hour=" + QString::number(time.hour()) + "&ver=1";
  if (klujeWin->getMoodCombo()->currentText() != "")
  {
    kdDebug(6969) << "KLuJeIO::slotPostevent -- moodCombo->currentText() == " << klujeWin->getMoodCombo()->currentText() << endl;
    if (klujeWin->getMoods()->getId(klujeWin->getMoodCombo()->currentText()) != NULL)
    {
      kdDebug(6969) << "KLuJeIO::slotPostevent -- adding prop_current_moodid=" << klujeWin->getMoods()->getId(klujeWin->getMoodCombo()->currentText()) << endl;
      postdata += "&prop_current_moodid=";
      postdata += klujeWin->getMoods()->getId(klujeWin->getMoodCombo()->currentText());
    } else
    {
      kdDebug(6969) << "KLuJeIO::slotPostevent -- adding prop_current_mood" << endl;
      postdata += "&prop_current_mood=" + klujeWin->getMoodCombo()->currentText();
    }
  }
  if (klujeWin->getSecurityCombo()->currentText() != "Public")
  {
    if (klujeWin->getSecurityCombo()->currentText() == "Private")
      postdata += "&security=private";
    else if (klujeWin->getSecurityCombo()->currentText() == "Friends only")
      postdata += "&security=usemask&allowmask=1";
  }
  if (klujeWin->getSongLineEdit()->text() != "")
  {
    kdDebug(6969) << "KLuJeIO::slotPostevent -- adding song=" << klujeWin->getSongLineEdit()->text() << endl;
    postdata += "&prop_current_music=" + klujeWin->getSongLineEdit()->text();
  }
  if (klujeWin->getJournalCombo()->currentText() != username)
  {
    postdata += "&usejournal=" + klujeWin->getJournalCombo()->currentText();
  }
  // TODO: I have *no* idea why not adding this trailing '&' makes things break
  postdata += "&";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  // send the request out to the livejournal server
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)), SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotPosteventResult(KIO::Job*)));
}

void
KLuJeIO::slotLogin()
{
  kdDebug(6969) << "KLuJeIO::slotLogin called" << endl;
  QString postdata = "mode=login&user=" + 
                     KURL::encode_string_no_slash(username) +
                     "&hpassword=" + KURL::encode_string_no_slash(password) + 
                     "&getmoods=" + QString::number(klujeWin->getMoods()->getHighestId()) + "&getmenus=1&getpickws=1" +
                     "&clientversion=KDE-KLuJe/" + VERSION + "&ver=1";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)), 
          SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job *)), SLOT(slotLoginResult(KIO::Job *)));
}

void
KLuJeIO::slotGetdaycounts()
{
  kdDebug(6969) << "KLuJeIO::slotGetdaycounts called" << endl;
  QString postdata = "mode=getdaycounts&user=" +
                     KURL::encode_string_no_slash(username) + 
                     "&password=" + KURL::encode_string_no_slash(password);
  // TODO: I have *no* idea why not adding this trailing '&' makes things break
  postdata += "&";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotGetdaycountsResult(KIO::Job*)));
}

void
KLuJeIO::slotGetevents(QDate date)
{
  kdDebug(6969) << "KLuJeIO::slotGetevents called" << endl;
  QString postdata = "mode=getevents&user=" +
                     KURL::encode_string_no_slash(username) + 
                     "&hpassword=" + KURL::encode_string_no_slash(password) + 
                     "&noprops=1&selecttype=day&year=" + 
                     QString::number(date.year()) + "&month=" + QString::number(date.month()) +
                     "&day=" + QString::number(date.day()) + "&ver=1";
  // TODO: I have *no* idea why not adding this trailing '&' makes things break
  postdata += "&";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotGeteventsByDateResult(KIO::Job*)));
}

void
KLuJeIO::slotGetevents(const QString& id)
{
  kdDebug(6969) << "KLuJeIO::slotGetevents called" << endl;
  QString postdata = "mode=getevents&user=" +
                     KURL::encode_string_no_slash(username) + 
                     "&hpassword=" + KURL::encode_string_no_slash(password) + 
                     "&selecttype=one&itemid=" + id + "&ver=1";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotGeteventsByIdResult(KIO::Job*)));
}

void
KLuJeIO::slotDataArrived(KIO::Job *job, const QByteArray& data)
{
  kdDebug(6969) << "Network data arrived. Progress ID is: " << job->progressId() << endl;
  QPair<QString, bool> *buf = response_buffers.find(job->name());
  if(buf == NULL)
  {
    kdDebug(6969) << "No data yet for " << job->name() << endl;
    buf = new QPair<QString, bool> ();
    buf->second = FALSE;
    response_buffers.insert(job->name(), buf);
  }

  if (buf->second)
  {
    buf->second = FALSE;
    buf->first = "";
  }

  buf->first += QString(data.data());
  if (data.size() == 0)
  {
    buf->second = TRUE;
    kdDebug(6969) << "KLuJeIO::slotDataArrived -- Done. Received:\n" << buf->first << endl;
  }
}

void
KLuJeIO::slotPosteventResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something has gone wrong
    kdDebug(6969) << "KLuJeIO::slotPosteventResult -- error!" << endl;
    klujeWin->statusBar()->message("Status: IO error");
  } else
  {
    // process response_buffer
    QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));
    response_buffers.remove(job->name());
    // clear dialog, *IF* submit was successful
    if (dict.find("success") == QString("OK"))
    {
      kdDebug(6969) << "KLuJeIO::slotPosteventResult -- clearing out the edit boxes" << endl;
      klujeWin->slotClear();
    } else
    {
      klujeWin->statusBar()->message(QString("Status: ") + dict.find("errmsg"));
    }
  }
}

void
KLuJeIO::slotLoginResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something has gone wrong
    kdDebug(6969) << "KLuJeIO::slotLoginResult -- error!" << endl;
    klujeWin->statusBar()->message("Status: IO error");
  } 
  else if (klujeWin != NULL)
  {
    // process response_buffer
    QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));
    response_buffers.remove(job->name());

    if (dict.find(QString("fastserver")) != 0)
    {
      // If fast server is false, set to true and save config
      if (!klujeWin->usesPayServer())
      {
        kdDebug(6969) << "Allowed to use fast servers" << endl;
        klujeWin->setUsePayServer(true);
      } else
      {
        kdDebug(6969) << "Already using fast servers" << endl;
      }
    } else
    {
      if (klujeWin->usesPayServer())
      {
        kdDebug(6969) << "Not using fast server anymore" << endl;
        klujeWin->setUsePayServer(false);
      }
    }

    klujeWin->statusBar()->message(QString("Status: ") + dict[QString("success")]);

    klujeWin->getSysTray()->populateMenu(dict);

    char * message = dict["message"];
    if (message)
    {
      KMessageBox::information(0, QString(message));
    }

    /**
     * Iterate over all shared journals and add them to the journalcombo
     * in the mainwin.  The nice thing about this is that the journals
     * are pre-sorted for us.
     */
    QStrList journalStrList;
    int sharedJournalCount = QString(dict["access_count"]).toInt();
    for(int i=1; i <=sharedJournalCount; ++i)
    {
      char * journal = (dict[QString("access_%1").arg(i)]);
      kdDebug(6969) << "Allowed to post to journal " << journal << endl;
      journalStrList.append(journal);
    }

    klujeWin->getJournalCombo()->clear();
    klujeWin->getJournalCombo()->insertItem(username);
    klujeWin->getJournalCombo()->insertStrList(journalStrList);

    klujeWin->getMoods()->populate(dict);

    klujeWin->getMoodCombo()->clear();
    klujeWin->getMoodCombo()->insertStrList(klujeWin->getMoods()->getSortedList());
    klujeWin->getMoodCombo()->completionObject()->insertItems(
      QStringList::fromStrList(klujeWin->getMoods()->getSortedList()));
    klujeWin->getMoodCombo()->setEditText("");
  }
}

void
KLuJeIO::slotGetdaycountsResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something went wrong
    kdDebug(6969) << "KLuJeIO::slotGetdaycountsResult -- error!" << endl;
    klujeWin->statusBar()->message("Status: IO error");
  } else if (klujeWin != NULL)
  {
    // process response_buffer
    QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));
    klujeWin->statusBar()->message(QString("Status: ") + dict[QString("success")]);
  }
  
  response_buffers.remove(job->name());
}

void
KLuJeIO::slotGeteventsByDateResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something went wrong
    kdDebug(6969) << "KLuJeIO::slotGeteventsByDateResult -- error!" << endl;
    klujeWin->statusBar()->message("Status: IO error");
  }
  // process response_buffer
  QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));
  response_buffers.remove(job->name());
  QDictIterator<char> it(dict);
  QRegExp indexRegexp = QRegExp("^(\\w+)_(\\d+)_(\\w+)");
  QRegExp eventRegexp = QRegExp("^events_.*_event$");
  QRegExp itemidRegexp = QRegExp("^events_.*_itemid$");
  QRegExp subjectRegexp = QRegExp("^events_.*_subject$");
  QRegExp timeRegexp = QRegExp("^events_.*_eventtime$");
  QRegExp securityRegexp = QRegExp("^events_.*_security$");
  QRegExp allowmaskRegexp = QRegExp("^events_.*_allowmask$");
  QDict<LJEvent> eventsDict;
  while (it.current())
  {
    if (it.currentKey().contains(indexRegexp))
    {
      indexRegexp.search(it.currentKey());
      if (eventsDict.find(indexRegexp.cap(2)) == NULL) eventsDict.insert(indexRegexp.cap(2), new LJEvent());
      LJEvent* event = eventsDict.find(indexRegexp.cap(2)); // convenience
      if (it.currentKey().contains(eventRegexp))
      {
        event->setText(decodeString(QString(it.current())));
      }
      else if (it.currentKey().contains(itemidRegexp))
      {
        event->setId(QString(it.current()).toInt());
      }
      else if (it.currentKey().contains(subjectRegexp))
      {
        event->setSubject(QString(it.current()));
      }
      else if(it.currentKey().contains(timeRegexp))
      {
        QDateTime datetime = QDateTime::fromString(QString(it.current()), Qt::ISODate);
        event->setDate(datetime.date());
        event->setTime(datetime.time());
      }
      else if (it.currentKey().contains(securityRegexp))
      {
        event->setSecurity(QString(it.current()));
      }
      else if (it.currentKey().contains(allowmaskRegexp))
      {
        event->setAllowMask(QString(it.current()));
      }
    }
    ++it;
  }
  // Copy LJEvents out of eventsDict and into a QPtrList
  QPtrList<LJEvent> *events = new QPtrList<LJEvent>();
  QDictIterator<LJEvent> it2(eventsDict);
	while (it2.current())
  {
    events->insert(0, it2.current());
    ++it2;
  }
	emit newEvents(events);
}

void
KLuJeIO::slotGeteventsByIdResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something went wrong
    kdDebug(6969) << "KLuJeIO::slotGeteventsByIdResult -- error!" << endl;
    klujeWin->statusBar()->message("Status: IO error");
  }
  else if (klujeWin != NULL)
  {
    QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));
    QDictIterator<char> it(dict);
    while (it.current())
    {
      // process response buffer
      ++it;
    }
  }

  response_buffers.remove(job->name());
}

QDict<char> 
KLuJeIO::createResponseTable(char* rawData)
{
  QDict<char> dict(17, FALSE);
  char* name = NULL;
  char* value = NULL;
  name = strtok(rawData, "\n");
  value = strtok(NULL, "\n");
  while ((name != NULL) && (value != NULL))
  {
    dict.insert(QString(name), value);
    name = strtok(NULL, "\n");
    value = strtok(NULL, "\n");
  }
  return dict;
}

void
KLuJeIO::slotConfigChanged(const KConfig &config)
{
  serverUrl = config.readEntry("ServerUrl", "");
  username = config.readEntry("Username", "");
  password = config.readEntry("Password", "");
  kdDebug(6969) << "KLuJeIO::slotConfigChanged -- serverUrl == " << serverUrl << endl;
  kdDebug(6969) << "KLuJeIO::slotConfigChanged -- username == " << username << endl;
  kdDebug(6969) << "KLuJeIO::slotConfigChanged -- password == " << password << endl;
}

void 
KLuJeIO::slotCheckFriends()
{
  kdDebug(6969) << "KLuJeIO::slotCheckFriends called" << endl;

  QString postdata = 
  "mode=checkfriends&user=" + KURL::encode_string(username) +
  "&hpassword=" + KURL::encode_string(password) + "&lastupdate=" +
  KURL::encode_string(klujeWin->getLastUpdate()) + "&ver=1&";

  kdDebug(6969) << "SENDING: " << postdata << endl;
  // send the request out to the livejournal server
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)), SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotCheckFriendsResult(KIO::Job*)));
}

void
KLuJeIO::slotCheckFriendsResult(KIO::Job *job)
{
  if (job->error() != 0)
  {
    // something has gone wrong
    kdDebug(6969) << "KLuJeIO::slotCheckFriendsResult -- error!" << endl;
    klujeWin->enablePolling();
  } else
  {
    // process response_buffer
    QDict<char> dict = createResponseTable(strdup(response_buffers[job->name()]->first.latin1()));

    kdDebug(6969) << "Built response table" << endl;

    QString status = dict[QString("success")];

    if (status != "OK")
    {
      kdDebug(6969) << "Check friends failed.  Pausing for 15 minutes" << endl;
      klujeWin->enablePolling();
      return;
    }

    QString newUpdate = dict[QString("lastupdate")];
    int newValue = QString((dict[QString("new")])).toInt();
    int interval = QString((dict[QString("interval")])).toInt();

    kdDebug(6969) << "Got checkfriends response: lastupdate=" << 
    newUpdate << " new=" << newValue << " interval=" << interval << endl;

    klujeWin->setInterval(interval);
    klujeWin->setLastUpdate(newUpdate);

    // Check to see if we have a new friend message
    if (newValue > 0)
    {
      kdDebug(6969) << "New friends detected, notifying" << endl;
      emit(checkfriendsNotify());
    } else
    {
      kdDebug(6969) << "No new friends, continuing poll" << endl;
      klujeWin->enablePolling();
    }
  }

  response_buffers.remove(job->name());
}

void KLuJeIO::slotSaveEvent(LJEvent event)
{
  kdDebug(6969) << "KLuJeIO::slotSaveEvent -- entered." << endl;
  QString postdata = "mode=editevent&user=" + KURL::encode_string(username) +
    "&hpassword=" + KURL::encode_string(password) + "&itemid=" + QString::number(event.getId()) + 
    "&event=" + KURL::encode_string(event.getText()) + "&subject=" + 
    KURL::encode_string(event.getSubject()) + "&year=" +
    QString::number(event.getDate().year()) + "&mon=" + QString::number(event.getDate().month()) +
    "&day=" + QString::number(event.getDate().day()) +
    "&min=" + QString::number(event.getTime().minute()) + 
    "&hour=" + QString::number(event.getTime().hour()) +
    "&security=" + event.getSecurity();
  if (event.getSecurity() == "usemask") postdata += "&allowmask=" + event.getAllowMask();
  postdata += "&ver=1";
  kdDebug(6969) << "SENDING: " << postdata << endl;
  KIO::TransferJob *job = KIO::http_post(serverUrl, postdata.utf8(), false);
  job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded");
  job->setName(getUniqueName().ascii());
  maybeAddFastServerCookie(job);
  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)), SLOT(slotDataArrived(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotSaveEventResult(KIO::Job*)));
}

void KLuJeIO::slotSaveEventResult(KIO::Job *job)
{
  if(job->error() != 0)
  {
    // something has gone wrong
    kdDebug(6969) << "KLuJeIO::slotSaveEventResult -- error!" << endl;
    klujeWin->enablePolling();
  }
  else
  {
    kdDebug(6969) << "KLuJeIO::slotSaveEventResult -- saved event successfully" << endl;
  }

  response_buffers.remove(job->name());
}

void KLuJeIO::maybeAddFastServerCookie(KIO::Job *job)
{
  if (klujeWin->usesPayServer())
  {
    kdDebug(6969) << "Using fast server for request" << endl;
    job->addMetaData(QString("Cookie"), QString("Cookie: ljfastserver=1")); 
  }
}

QString KLuJeIO::decodeString(const QString &str)
{
  QString retval = str;
  retval = retval.replace(QRegExp("\\+"), " ");
  retval = KURL::decode_string(retval);
  return retval;
}

KLuJeIO::~KLuJeIO()
{
}
