/***************************************************************************
                          kluje.h  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLUJEIO_H
#define KLUJEIO_H

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <qobject.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kconfig.h>
#include <qdict.h>
#include <qpair.h>
#include <qptrlist.h>
#include "ljevent.h"

class QString;
class KLuJe;
class EditEventsDialog;

/** KLuJe is the base class of the project */
class KLuJeIO : public QObject 
{
  Q_OBJECT 
  
public:
  
  /** construtor */
  KLuJeIO(KLuJe *win, QString name, QString pass, QString server);
  /** destructor */
  ~KLuJeIO();

signals:

  void checkfriendsNotify();
  void newEvents(QPtrList<LJEvent> *events);

public slots:

  /**
   * Send a new journal entry to the server.
   **/
  void slotPostevent();
  void slotLogin();
  void slotGetdaycounts();
  void slotGetevents(QDate);
  void slotGetevents(const QString&);
  void slotCheckFriends();
  void slotSaveEvent(LJEvent event);
  void slotConfigChanged(const KConfig &config);

private slots:
  
  void slotPosteventResult(KIO::Job*);
  void slotLoginResult(KIO::Job*);
  void slotGetdaycountsResult(KIO::Job*);
  void slotGeteventsByDateResult(KIO::Job*);
  void slotGeteventsByIdResult(KIO::Job*);
  void slotCheckFriendsResult(KIO::Job*);
  void slotSaveEventResult(KIO::Job*);
  void slotDataArrived(KIO::Job*, const QByteArray&);

private:

  QDict<char> createResponseTable(char* rawData);
  void maybeAddFastServerCookie(KIO::Job*);
  QString decodeString(const QString &str);
  QString getUniqueName() { return QString("response %1").arg(++response_counter); }
  
  KLuJe * klujeWin;

  // config stuff
  QString username;
  QString password;
  QString serverUrl;

  unsigned long response_counter;

  /**
   * Used for processing server responses. QDict keeps a separate buffer
   * for each response, with responses being distinguished by a unique
   * name assigned to the KIO::Job.
   */ 
  QDict<QPair<QString, bool> > response_buffers;
};

#endif
