
/***************************************************************************
                            klujemoods.cpp  -  description
                             -------------------
    begin                : Sun Jun 09 18:07:24 EST 2002
    copyright            : (C) 2002 by Ryan Breen
    email                : ryan@ryanbreen.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klujemoods.h"

#include <qdict.h>
#include <qstring.h>
#include <qstringlist.h>

#include <kconfig.h>
#include <kdebug.h>

KLuJeMoods::KLuJeMoods(KConfig * conf) 
: highestIdx(0)
{
  config = conf;
  readFromConfig();
}

void KLuJeMoods::readFromConfig() 
{
  config->setGroup("Moods");

  QStringList names = config->readListEntry("names");
  QStringList ids = config->readListEntry("ids");

  if(names.count() != ids.count())
  {
    kdDebug(6969) << "Name and id lists don't match, starting from scratch" << endl;
    kdDebug(6969) << "Name count == " << names.count() << endl;
    kdDebug(6969) << "ID count == " << ids.count() << endl;
  } else {
    // Iterate over the lists, adding to internal storage
    
    QValueList<QString>::iterator nameIt = names.begin();
    QValueList<QString>::iterator idIt = ids.begin();
    while((nameIt != names.end()) && 
          (idIt != ids.end()))
    {
      kdDebug(6969) << "Read in " << *nameIt << "::" << *idIt << endl;
      addEntry(*idIt, *nameIt);
      ++idIt;
      ++nameIt;
    }

    highestIdx = config->readNumEntry("highest");
  }

  kdDebug(6969) << "There are " << sortedMoods.count() << " moods in sorted list" << endl;
}

void KLuJeMoods::writeToConfig() 
{
  QStringList names;
  QStringList ids;

  QMapIterator<QString, QString> it = moods.begin();
  while(it != moods.end())
  {
    kdDebug(6969) << "Writing " << it.key() << " to names list" << endl;
    names.append(it.key());
    kdDebug(6969) << "Writing " << it.data() << " to ids list" << endl;
    ids.append(it.data());
    ++it;
  }

  kdDebug(6969) << "Writing " << names.count() << " names" << endl;
  kdDebug(6969) << "Writing " << ids.count() << " ids" << endl;

  config->setGroup("Moods");
  config->writeEntry("names", names);
  config->writeEntry("ids", ids);
  config->writeEntry("highest", highestIdx);
  config->sync();
}

void KLuJeMoods::populate(const QDict<char> & dict)
{

  // fill the moods table
  QDictIterator<char> it(dict);
  int count = QString(dict["mood_count"]).toInt();
  
  kdDebug(6969) << "Adding " << count << " new items to the moods store" << endl;

  for(int i = 1; i <= count; ++i)
  {
    QString prefix = QString("mood_%1_").arg(i);
    QString moodName = dict[prefix + "name"];
    kdDebug(6969) << "Looking for " << moodName << endl;
    QString moodId = dict[prefix + "id"];
    addEntry(moodId, moodName);

    if(i == count) 
      highestIdx = moodId.toInt();
  }

  if(count > 0)
  {
    writeToConfig();
  }

}

void KLuJeMoods::addEntry(QString id, QString name)
{
  kdDebug(6969) << "Adding mood entry " << name << "::" << id << endl; 
  moods.insert(name, id);
  sortedMoods.inSort(name.latin1());
}

