/***************************************************************************
                          klujemoods.h  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Ryan Breen
    email                : ryan@ryanbreen.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLUJEMOODS_H
#define KLUJEMOODS_H

#include <qdict.h>
#include <qmap.h>
#include <qstrlist.h>

class QStrList;
class QString;

class KConfig;

class KLuJeMoods {
  
  public:
  /** construtor */
  KLuJeMoods(KConfig * conf);
  /** destructor */
  ~KLuJeMoods() { }

public:
  void populate(const QDict<char> & dict);
  int getHighestId() { return highestIdx; }
  QString getId(QString name) { return (moods[name]); }
  QStrList getSortedList() { return sortedMoods; }

protected:
  void addEntry(QString id, QString name);
  void readFromConfig();
  void writeToConfig();

private:
  QStrList sortedMoods;
  QMap<QString, QString> moods;
  int highestIdx;
  KConfig * config;
  
};

#endif
