/***************************************************************************
                            kluje.cpp  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Buddy Brewer
    email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klujesystray.h"
#include "kluje.h"

#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <kprocess.h>
#include <kwin.h>
#include <kmenubar.h>

#include <qevent.h>

#include <qstring.h>
#include <qregexp.h>

#include <qptrvector.h>

KLuJeSysTray::KLuJeSysTray(KLuJe *parent) : 
KSystemTray(), myParent(parent), myParentVisible(true)
{
  KIconLoader *loader = KGlobal::iconLoader();
  this->setPixmap(loader->loadIcon("kluje", KIcon::Small));

  // popup menu for right mouse button
  myPopup = new KPopupMenu();
  myPopup->insertTitle(i18n("KLuJe"));

  urls = new QPtrVector<QUrl> (20);

  urlMenu = new KPopupMenu();
  urlMenu->setEnabled(false);

  myPopup->insertItem(SmallIcon("enhanced_browsing"), 
                      i18n("&Links"), 
                      urlMenu);
  
  myPopup->insertSeparator();
  myPopup->insertItem(SmallIcon("configure"), 
                      i18n("&Preferences..."), 
                      myParent->getPrefs(), 
                      SLOT(show()));

  myPopup->insertSeparator();
  myPopup->insertItem(SmallIcon("exit"), i18n("E&xit"), myParent, SLOT(slotExit()));

  connect(urlMenu, SIGNAL(activated(int)), this, SLOT(selectedLink(int)));

  this->show();
}

void 
KLuJeSysTray::mousePressEvent(QMouseEvent *e)
{
  // show or hide mainwin on left click
  if ( e->button() == LeftButton ) {

    if (myParentVisible) myParent->hide();
    else myParent->show();

    myParentVisible = !myParentVisible;
  }

  // open popup menu on right mouse button
  if ( e->button() == RightButton ) {
    kdDebug(6969) << "emitting userClicked signal" << endl;
    emit userClicked();

    myPopup->popup(e->globalPos());
    myPopup->exec();
  }

}

KLuJeSysTray::~KLuJeSysTray()
{
}

void KLuJeSysTray::selectedLink(int id)
{
  QUrl url = *(urls->at(id));

  kdDebug(6969) << "User selected link " << url << endl;

  KProcess *proc = new KProcess();

  *proc << "konqueror";
  *proc << url.toString().latin1();
  proc->start( KProcess::DontCare );
}

/** Public entry point to popup menu population **/
void KLuJeSysTray::populateMenu(const QDict<char> & dict)
{
  if(!urlMenu->isEnabled())
  {
    populateMenu(urlMenu, dict, 0);
    myParent->menuBar()->insertItem(i18n("&Links"), urlMenu);
    urlMenu->setEnabled(true);
  }
}

/** Internal menu population method.  Does all the work.  Gets none of the love. */
void KLuJeSysTray::populateMenu(KPopupMenu * popMenu, const QDict<char> & dict, int menuNum)
{
  lastMenuIndex = menuNum;

  QString menuCountStr = QString("menu_%1_count").arg(menuNum);
  int count = QString(dict[menuCountStr.latin1()]).toInt();
  kdDebug(6969) << "There are " << count << " items in the menu" << endl;
  for (int i =1; i <= count ; ++i) {

    QString menu = QString("menu_%1_%2_").arg(menuNum).arg(i);

    char * urlStr = dict[menu + "url"];
    kdDebug(6969) << "Found url string " << urlStr << " for menu " << menu << endl;
    QString text = QString(dict[QString(menu + "text").latin1()]);      

    if (urlStr != 0) {
      QString url = QString(urlStr);
      kdDebug(6969) << "Menu " << i << " is " << text << "::" << url << endl;
      int id = urls->count();
      urls->insert(id, new QUrl(url));
      popMenu->insertItem(text, id);
    } else if (dict[menu + "sub"] != 0) {
      kdDebug(6969) << "Got sub menu " << lastMenuIndex + 1 << endl;
      KPopupMenu * subMenu = new KPopupMenu();
      connect(subMenu, SIGNAL(activated(int)), this, SLOT(selectedLink(int)));
      populateMenu(subMenu, dict, lastMenuIndex + 1);
      popMenu->insertItem(text, subMenu);
    } else {
      if (text == "-") {
        kdDebug(6969) << "Add separator" << endl;
        popMenu->insertSeparator();
      } else {
        kdDebug(6969) << "Add text " << text << endl;
        popMenu->insertItem(text);
      }
    }
  }      
}
