/***************************************************************************
                          klujesystray.h  -  description
                             -------------------
    begin                : Mon Jan 28 22:22:24 EST 2002
    copyright            : (C) 2002 by Ryan Breen
    email                : ryan@ryanbreen.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLUJESYSTRAY_H
#define KLUJESYSTRAY_H

#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <qurl.h>
#include <qptrvector.h>
#include <qdict.h>

class KLuJe;
class QMouseEvent;
class QEvent;

class KLuJeSysTray : public KSystemTray {
  Q_OBJECT 
  public:
  /** construtor */
  KLuJeSysTray(KLuJe * parent);
  /** destructor */
  ~KLuJeSysTray();

  void populateMenu(const QDict<char> & values);

signals:
  void userClicked();

public slots:
  void selectedLink(int);

protected:

  void populateMenu(KPopupMenu * menu, const QDict<char> & values, int menuNum);
  void mousePressEvent(QMouseEvent *);
  
private:
  KLuJe * myParent;
  KPopupMenu * myPopup;
  KPopupMenu * urlMenu;

  int lastMenuIndex;

  QPtrVector<QUrl > * urls;

  bool myParentVisible;
};

#endif
