#include "ljevent.h"
#include <kdebug.h>

LJEvent::LJEvent()
{
  id = -1;
  subject = "";
}

LJEvent::LJEvent(const LJEvent &event) : id(event.getId()), date(event.getDate()), time(event.getTime()), subject(event.getSubject()), text(event.getText())
{
}

LJEvent::LJEvent(int id, QDate date, QString subject, QString text, 
  QString security = "public", QString allowmask = "1")
{
  this->id = id;
  this->date = date;
  this->subject = subject;
  this->text = text;
  this->security = security;
  this->allowmask = allowmask;
}

void LJEvent::setId(int id)
{
  kdDebug(6969) << "setId() -- " << id << endl;
  this->id = id;
}

int LJEvent::getId() const
{
  return id;
}

void LJEvent::setDate(QDate date)
{
  kdDebug(6969) << "setDate() -- " << date.toString() << endl;
  this->date = date;
}

QDate LJEvent::getDate() const
{
  return date;
}

void LJEvent::setTime(QTime time)
{
  kdDebug(6969) << "setTime() -- " << time.toString() << endl;
  this->time = time;
}

QTime LJEvent::getTime() const
{
  return time;
}

void LJEvent::setSubject(QString subject)
{
  this->subject = subject;
}

QString LJEvent::getSubject() const
{
  return subject;
}

void LJEvent::setText(QString text)
{
  this->text = text;
}

QString LJEvent::getText() const
{
  return text;
}

void LJEvent::setSecurity(QString security)
{
  this->security = security;
}

QString LJEvent::getSecurity() const
{
  return security;
}

void LJEvent::setAllowMask(QString allowmask)
{
  this->allowmask = allowmask;
}

QString LJEvent::getAllowMask() const
{
  return allowmask;
}
