/***************************************************************************
              preferencesdialog.cpp  -  description
               -------------------
  begin                : Mon Feb  4 14:58:34 EST 2002
  copyright            : (C) 2002 by Buddy Brewer
  email                : buddy@buddybrewer.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "preferencesdialog.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qvbox.h>
#include <kfontdialog.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <qcheckbox.h>

#include <kmdcodec.h>

PreferencesDialog::PreferencesDialog(KConfig *config, QWidget *parent, 
                                     const char *name, bool modal) : 
KDialogBase(IconList, QString("Preferences"), 
            /*Help|*/Default|Apply|Ok|Cancel, Ok, parent, name, modal, true)
{
  this->setIcon(SmallIcon("configure"));
  kconfig = config;
  setupServerPage();
  setupCheckFriendsPage();
}

void PreferencesDialog::setupServerPage()
{
  QFrame *page = addPage(QString("Server"), 
                         QString("LiveJournal connection info"), 
                         SmallIcon("connect_established"));
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());
  if(topLayout == 0)
  {
    return;
  }
  QGridLayout *gbox = new QGridLayout( 5, 2 );
  topLayout->addLayout(gbox);

  kconfig->setGroup("ServerInfo");

  QLabel* lblUsername = new QLabel("Username", page);
  gbox->addWidget(lblUsername, 0, 0);
  usernameEdit = new KLineEdit(page);
  usernameEdit->setText(kconfig->readEntry("Username"));
  gbox->addWidget(usernameEdit, 0, 1);

  gbox->addRowSpacing( 2, spacingHint()*2 );

  QLabel* lblPassword = new QLabel("Password", page);
  gbox->addWidget(lblPassword, 1, 0);
  passwordEdit = new KLineEdit(page);
  passwordEdit->setEchoMode(QLineEdit::Password);
  gbox->addWidget(passwordEdit, 1, 1);

  topLayout->addStretch(10);
}

void PreferencesDialog::setupCheckFriendsPage()
{
  QFrame *page = addPage(QString("CheckFriends"), 
                         QString("Friend post notification settings"), 
                         SmallIcon("personal"));
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());
  if(topLayout == 0) return;
  QGridLayout *gbox = new QGridLayout( 5, 2 );
  topLayout->addLayout(gbox);

  kconfig->setGroup("CheckFriends");

  QLabel* lblEnablePolling = new QLabel("Enable polling", page);
  gbox->addWidget(lblEnablePolling, 0, 0);
  checkFriendsCheck = new QCheckBox(page);
  checkFriendsCheck->setChecked(kconfig->readBoolEntry("enabled", true));
  gbox->addWidget(checkFriendsCheck, 0, 1);

  gbox->addRowSpacing( 2, spacingHint()*2 );

  topLayout->addStretch(10);
}

void PreferencesDialog::slotOk()
{
  slotApply();
  accept();
}

void PreferencesDialog::slotApply() 
{
  kconfig->setGroup("ServerInfo");

  kconfig->writeEntry("Username", usernameEdit->text());
  
  // Get MD5 digest for password and store that
  if(passwordEdit->text() != "")
  {
    kdDebug(6969) << "Password modified" << endl;
    KMD5 md5(passwordEdit->text());
    kconfig->writeEntry("Password", QString(md5.hexDigest()));
  }

  kconfig->setGroup("CheckFriends");
  kconfig->writeEntry("enabled", checkFriendsCheck->isChecked());

  emit(configChanged(*kconfig));
}

void PreferencesDialog::slotDefault()
{
  usernameEdit->setText(kconfig->readEntry("Username"));
}

PreferencesDialog::~PreferencesDialog()
{
}
