/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <knuminput.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qstring.h>
#include "divxlavcoptdialog.h"

DivXLavcOptDialog::DivXLavcOptDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
: DivXLavcOptionsDialog(parent,name, modal,fl)
{
}

DivXLavcOptDialog::~DivXLavcOptDialog()
{
}

QString DivXLavcOptDialog::getOptions(int pass)
{
	QString Opts;
	Opts = ":vbitrate=" + spinBitrate->cleanText() +
			":keyint=" + spinKeyframe->cleanText();
			":vqmin=" + spinVqmin->cleanText();
			":vqmax=" + spinVqmax->cleanText();
			":vlelim=" + spinVlelim->cleanText();
			":vcelim=" + spinVcelim->cleanText();
			
	QString tempS;
	tempS = tempS.setNum(spinLumiMask->value()); // spinLumiMask and spinDarkMask are KDoubleSpinBox !!!
	Opts += ":lumi_mask=" + tempS;
	tempS = tempS.setNum(spinDarkMask->value());
	Opts += ":dark_mask=" + tempS;
	tempS = tempS.setNum(comboVme->currentItem());
	Opts += ":vme=" + tempS;
	tempS = tempS.setNum(comboDCT->currentItem());
	Opts += ":vfdct=" + tempS;
	tempS = tempS.setNum(comboIDCT->currentItem());
	Opts += ":idct=" + tempS;
	
	if (checkHighQuality->isChecked()) Opts += ":vhq";
	if (checkGrayscale->isChecked()) Opts += ":gray";
	if (checkQuaterPelMotion->isChecked()) Opts += ":qpel";
	if (check4Motion->isChecked()) Opts += ":v4mv";
        if (pass !=0) Opts += ":vpass="+QString::number(pass);
	return Opts;
}

#include "divxlavcoptdialog.moc"

