/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KONVERTERDIALOG_H
#define KONVERTERDIALOG_H

#include <qlineedit.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qprocess.h>
#include <qtextbrowser.h>
#include <qtabwidget.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qtoolbox.h>
#include <qstringlist.h> 
#include <qlistbox.h> 
#include <qobject.h>
#include <qslider.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qregexp.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qmovie.h>

//Splitter
#include <qfileinfo.h>
#include <kurl.h>
#include <klocale.h>

// kdoublespinbox widget
#include <knuminput.h>
// Help menu
#include <kpushbutton.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>

#include "KonverterMainDialog.h" // header of ui file
#include "aboutdialog.h"
#include "nooptdialog.h"
#include "mp3optdialog.h"
#include "pcmoptdialog.h"
#include "divxoptdialog.h"
#include "xvidoptdialog.h"
#include "mpeg2optdialog.h"
#include "mpeg1optdialog.h"
#include "divxlavcoptdialog.h"
#include "rawoptdialog.h"
#include "mp2optdialog.h"
#include "ac3optdialog.h"
#include "preview.h"
#include "konvprocess.h"
#include "kxinewidget.h" //Xine
#include "workdlg.h" //Work Dialog
#include "soundfilters.h"
#include "videofilters.h"

#include <iostream>
#include <cstdlib>
#include <cstdio>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <unistd.h>

class KonverterDialog : public KonverterMainDialog
{
  Q_OBJECT

public:
  KonverterDialog(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KonverterDialog();

public slots:
  virtual void          SelectInputFile();
  virtual void          UpdateConversionCommandString();  
  virtual void          UpdateConcatCommandString();  
  virtual void          ExitKonverter();    
  virtual void          TabChanged();      
  virtual void          SelectOutputDir();
  virtual void          SelectOutputDirConcat();
  virtual void          SelectJoinFiles();
  virtual void          RemoveJoinFile();
  virtual void          ShowAboutDialog();
  virtual void          ShowHelpDialog();
  virtual void          ShowVideoOptionsDialog();
  virtual void          ShowAudioOptionsDialog();
  virtual void          ShowVideoFilter();
  virtual void          ShowAudioFilter();
  virtual void          ExecuteCommandString();
  
  // main mencoder transformation process
  virtual void    readFromStdout();
  virtual void    readFromStderr();    
  virtual bool    processExiting();
  
  virtual void    scrollToTop();  
      
  //Split tool
  virtual void SplitNameChanged();
  virtual void SplitSliderChanged();
  virtual void SplitSpinChanged();
  virtual void SplitReadFromStdout();
  virtual void SplitProcessExitting();
  
  virtual void OpenPreview(); //Open Preview Form
  virtual void PrAoChanged();
  virtual void ExecWorkW();//connects to workDlg widget aka cancel button
  
  //twopass
  virtual void ExtraOptsCheck();
  virtual void TwoPassChanged();
protected:

protected slots:

private:    
    // internal execute funxtion
    void          ConvertFile();
    void          ConcatFile();

    // for mencoder process
    KonvProcess* mencoder;
    bool running;
    bool appendText;
    QString mencOptions;
    
    // for progress bar calculation
    QString LastStatus;    
    QString OutputLine;
    int ProgressIndicator;
    int MBPos;
        
    // define codec options
    QString AudioCodec;  
    QString VideoCodec;
    
    // define additional codec options
    QString VideoOpts;
    QString AudioOpts;
    
    //define filters
    QString AudioFilt;
    QString VideoFilt;
    
    // check for already created instances
    bool MP3OptionsCheck;
    bool PCMOptionsCheck;
    bool MP2OptionsCheck;
    bool AC3OptionsCheck;
    bool NoOptionsCheck;

    bool DivXOptionsCheck;
    bool XvidOptionsCheck;
    bool MPEG2OptionsCheck;
    bool MPEG1OptionsCheck;
    bool DivXLavcOptionsCheck;
    bool RawOptionsCheck;
    
    bool SoundFiltersCheck;
    bool VideoFiltersCheck;
        
    // Options dialogs
    NoOptDialog* noOpt;    
    
    MP3OptDialog* MP3Opt;
    MP2OptDialog* MP2Opt;
    AC3OptDialog* AC3Opt;
    PCMOptDialog* PCMOpt;
    
    DivXOptDialog* DivXOpt;
    XvidOptDialog* XvidOpt;
    MPEG2OptDialog* MPEG2Opt;
    MPEG1OptDialog* MPEG1Opt;
    DivXLavcOptDialog* DivXLavcOpt;
    RawOptDialog* RawOpt;
     
     // Codec options indicators
     bool withDivx3;
    
    //Splitting
    bool SpFileExists;
    void getSplitter();
    void SetParts(int Parts);
    void SplitMovie();
    void SplitConstructCommand (int part);
    KonvProcess* SplitProcess;
    int SplitFileSize;
    int SplitMovParts;
    int SplitCurPart;
    int SplitPosI;
    int SplitPosVal;
    int SplitPartSize;
    QString SplitPosS;
    QString SplitTemp;
    QMessageBox* SplitDoneMessage;
     //for QProces
    QString SplitOutputLine;
    QString SplitLastStatus;
    
    //Function to convert Console path
    QString ChShellEscape(QString escshell);
    
    Preview* Pr; //Preview Form
    
    //Load the movie and get all possible info
    KXineWidget* movInfo;
    void ChangeMovInfo();
    
    //Working dialog
    workdlg* workDlg;
    bool woWorking;
    
    //Passes
    int mencPass;
    
    KHelpMenu *helpPopUp; //help menu
    SoundFilters* SFDialog;//SoundFiltersDialog
    VideoFilters* VFDialog;//VideoFiltersDialog
};

#endif
