/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "konvprocess.h"

KonvProcess::KonvProcess(QObject *parent, const char *name)
 : QProcess(parent, name)
{
}


KonvProcess::~KonvProcess()
{
}

void KonvProcess::setInFile( QString IFile )
{
   InFile = CheckSlashes( IFile );
   UpdateCommand();
}

void KonvProcess::setOutFile( QString OFile )
{
   OutFile = CheckSlashes( OFile );
   UpdateCommand();
}

void KonvProcess::setMencOpts( QStringList MencOpts)
{
   Options = MencOpts;
   UpdateCommand();
}

void KonvProcess::setMencOpts( QString MencOpts)
{
   QStringList tempList;
   tempList = tempList.split( " ", MencOpts );
   Options = tempList;
   UpdateCommand();
}

QString KonvProcess::getCommand()
{
   QStringList opts = arguments();
   return opts.join(" ");
}

QStringList KonvProcess::getOptions()
{
   return Options;
}

void KonvProcess::UpdateCommand()
{
   QStringList tempList; //temporary string list
   
   tempList = Options;
   tempList += InFile;
   tempList += "-o";
   tempList +=OutFile;
   setArguments( tempList );
}

QString KonvProcess::CheckSlashes( QString Slashes)
{
   Slashes.replace( "//", "/" );
   return Slashes;
}

QString KonvProcess::inFile()
{
   return InFile;
}

QString KonvProcess::outFile()
{
   return OutFile;
}

void KonvProcess::addOption( QString opt )
{
   Options += opt;
}
#include "konvprocess.moc"
