/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "konverterdialog.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>


static const char description[] =
    I18N_NOOP("A KDE video conversion tool");

static const char version[] = "0.92-beta1";

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("konverter", I18N_NOOP("Konverter"), version, description, KAboutData::License_GPL, "(C) 2004 Marco Kraus", 0, 0, "marco@libsdl.de");
    about.addAuthor( "Marco Kraus", 0, "marco@libsdl.de" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KonverterDialog *mainWin = 0;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    mainWin = new KonverterDialog();
    app.setMainWidget( mainWin );
    mainWin->show();

    args->clear();

    return app.exec();
}
