/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************
$Id: mp3optdialog.cpp,v 1.4 2004/11/12 21:10:01 nikola Exp $
*/

#include <qbutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include "mp3optdialog.h"

MP3OptDialog::MP3OptDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
: MP3OptionsDialog(parent,name, modal,fl)
{
}

MP3OptDialog::~MP3OptDialog()
{
}

void MP3OptDialog::checkVBRToggled(int state)
{
	if (state == QButton::On)
	{
		checkABR->setChecked(false);
		checkCBR->setChecked(false);
		checkPreset->setChecked(false);
	}
}

void MP3OptDialog::checkABRToggled(int state)
{
	if (state == QButton::On)
	{
 		checkVBR->setChecked(false);
		checkCBR->setChecked(false);
		checkPreset->setChecked(false);
	}
}

void MP3OptDialog::checkCBRToggled(int state)
{
	if (state == QButton::On)
	{
		checkABR->setChecked(false);
		checkVBR->setChecked(false);
		checkPreset->setChecked(false);
	}
}

void MP3OptDialog::checkPresetToggled(int state)
{
	if (state == QButton::On)
	{
 		checkABR->setChecked(false);
 		checkVBR->setChecked(false);
 		checkCBR->setChecked(false);
	}
}

QString MP3OptDialog::getOptions()
{
	QString tempS, Opts;
	
	tempS = tempS.setNum(comboMode->currentItem());
	Opts = " -lameopts mode=" + tempS;
	if (checkFastEncoding->isChecked())
		Opts += ":fast";
		
	if (checkVBR->isChecked())
	{
		tempS = tempS.setNum(comboVBRMethod->currentItem());
		Opts += ":vbr=" + tempS;
		Opts += ":q=" + spinVRBQuality->cleanText();
	}
	else if (checkCBR->isChecked())
	{
		Opts += ":cbr:br=" + spinCBRBitrate->cleanText();
	}
	else if (checkPreset->isChecked())
	{
		Opts += ":preset=" + comboPreset->currentText();
	}
	else
	{ // Then it must be checkABR
		Opts += ":abr:br=" + spinCBRBitrate->cleanText();
	}

	return Opts;
}

void MP3OptDialog::ExitDialog()
{
  this->close();
}

#include "mp3optdialog.moc"

