/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kconfig.h>
#include "preview.h"

Preview::Preview(QWidget *parent, const char *name)
 : PreviewForm(parent, name)
{
//Load configs
KConfig &config = *KGlobal::config();


mLayout = new QBoxLayout(previewLayoutBox, QBoxLayout::LeftToRight);
mLayout->setAutoAdd( TRUE );

//original Preview frame
horPreviewLayout = new QHBoxLayout(orPreviewFrame);
horPreviewLayout->setAutoAdd( TRUE );

config.setGroup("Options");
if (config.readBoolEntry("PrAoBoth",false))
   orXine = new KXineWidget(orPreviewFrame, "orXine", QString::null, QString::null, "none", QString::null, false, false);
else
   orXine = new KXineWidget(orPreviewFrame, "orXine", QString::null, QString::null, config.readEntry("PrAoDriver","arts"), QString::null, false, false);

//converted Preview frame
hconvPreviewLayout = new QHBoxLayout(convPreviewFrame);
hconvPreviewLayout->setAutoAdd( TRUE );
prXine = new KXineWidget( convPreviewFrame, "prXine", QString::null, QString::null, config.readEntry("PrAoDriver","arts"), QString::null, false, false );
StopBoth();

mencPreview = new KonvProcess();
connect( mencPreview, SIGNAL(processExited()),this, SLOT(processExiting()) ); 
//Stop playback when preview finished
connect( prXine, SIGNAL(signalPlaybackFinished()),this, SLOT(StopBoth()) );
}

Preview::~Preview()
{
  //Delete temporary Preview file (if exists)
  tempFile = new QFile("/tmp/konverterpreview.avi");
  tempFile->remove();
 delete tempFile;
}

void Preview::getFileKMPreview(QStringList MencOpts, QString IFile)
{
   if ( IFile != "" )
   {
      if ( IFile != IFileTemp ) orXine->appendToQueue(IFile);
      StopBoth();
      //Encode
      tempOptions = MencOpts;
      mencPreview->setMencOpts( MencOpts );
      mencPreview->addOption( "-endpos");
      mencPreview->addOption( QString::number( secsToGrabSpinBox->value() ) );
      mencPreview->setInFile( IFile );
      IFileTemp = IFile;
      mencPreview->setOutFile( "/tmp/konverterpreview.avi" );
      mencPreview->start();
      PlayButton->setEnabled(false);
      setCaption( "Preview - Generating Preview" );
}
}

void Preview::getFileKMPreview()
{
   getFileKMPreview ( tempOptions, IFileTemp );
}

void Preview::ChangeSecToGrab()
{
   //Stop current Playback
   StopBoth();
   
   getFileKMPreview();
}

void Preview::PlayBoth()
{
   //Stop current Playback
   StopBoth();
   //Play both Movies
   orXine->appendToQueue(IFileTemp);
   prXine->appendToQueue( "/tmp/konverterpreview.avi" );
   orXine->slotPlay();
   prXine->slotPlay();
}

void Preview::StopBoth()
{
   orXine->slotStop();
   prXine->slotStop();
}

void Preview::ClosePreview()
{
   StopBoth();
   delete orXine;
   delete prXine;
   close();
}

void Preview::ChangeLayout()
{
   if ( HVLComboBox->currentItem() != 0 )
   {
      mLayout->setDirection(QBoxLayout::TopToBottom);
   }
   else
   {
      mLayout->setDirection(QBoxLayout::LeftToRight);
   }
}

void Preview::prPlayerStateChanged()
{
}

void Preview::processExiting()
{
          switch (mencPreview->exitStatus()) {
               case 0:
		    PlayButton->setEnabled(true);
		    setCaption( "Preview - Preview Ready" );
                    break;
               case 1:
                    setCaption( "Preview - Mencoder returned an error" );
                    break;
               case 139: //segmentation fault in mencoder
                    setCaption( "Preview - Mencoder crashed, sorry. Try again" );  
                    break;
          }
}
#include "preview.moc"
