/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREVIEW_H
#define PREVIEW_H

#include <qprocess.h>
#include <qfile.h>
#include <qlayout.h>
#include <qobject.h>
#include <qframe.h>
#include <qstring.h>
#include <qspinbox.h>
#include <qwidget.h>
#include <qhbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#include <PreviewForm.h>
#include "konvprocess.h"
#include "kxinewidget.h"

/**
Preview Form for konverter

@author Darjus Loktevic
*/
class Preview : public PreviewForm
{
Q_OBJECT
public:
    Preview(QWidget *parent = 0, const char *name = 0);

    ~Preview();

     void getFileKMPreview(QStringList MencOpts, QString IFile);
     void getFileKMPreview();
    
private:
    QObject* origPreview;
    QObject* convPreview;
    QHBoxLayout* horPreviewLayout;
    QHBoxLayout* hconvPreviewLayout;
    QBoxLayout* mLayout;
    int SecsToGrab;
    QString IFileTemp;
    QString encCmdPreviewProc;
    KonvProcess* mencPreview;
    QFile* tempFile;
    QStringList tempOptions;
    KXineWidget* orXine;
    KXineWidget* prXine;
    
public slots:
    virtual void   ChangeSecToGrab();
    virtual void   PlayBoth();
    virtual void   StopBoth();
    virtual void   ClosePreview();
    virtual void   ChangeLayout();

private slots:
    virtual void   prPlayerStateChanged();
    virtual void   processExiting();
};

#endif
