/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "soundfilters.h"

SoundFilters::SoundFilters(QWidget *parent, const char *name)
 : SoundFiltersDialog(parent, name)
{
}


SoundFilters::~SoundFilters()
{
}

QString SoundFilters::getOptions()
{
   QString Opts;
   if ( ExStereoCheckBox->isChecked() || NormalizeCheckBox->isChecked())
   {
      Opts = " -af ";
      if (ExStereoCheckBox->isChecked())
      {
         Opts += "extrastereo="+QString::number(ExStereoKDoubleSpinBox->value());
	 if (NormalizeCheckBox->isChecked()) Opts +=",volnorm";
      }
      else if (NormalizeCheckBox->isChecked()) Opts +="volnorm";
      Opts +=" -af-adv force="+QString::number(FIAFComboBox->currentItem());
   }
   
   return Opts;
}

void SoundFilters::ExStereoCheck()
{
   if(ExStereoCheckBox->isChecked())
      ExStereoKDoubleSpinBox->setEnabled(true);
   else
      ExStereoKDoubleSpinBox->setEnabled(false);
}
#include "soundfilters.moc"
