/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "workdlg.h"

workdlg::workdlg(QWidget *parent, const char *name)
 : WorkDialog(parent, name)
{
   OverProgressBar->hide();
   OverallLabel->hide();
}


workdlg::~workdlg()
{
}

void workdlg::working(QString FCaption)
{
   OverProgressBar->hide();
   OverallLabel->hide();
   buttonClose->setEnabled(false);
   buttonCancel->setEnabled(true);
   setCaption(FCaption);
}

void workdlg::passworking(QString FCaption)
{
   OverProgressBar->show();
   OverallLabel->show();
   buttonClose->setEnabled(false);
   buttonCancel->setEnabled(true);
   setCaption(FCaption);
}

void workdlg::doneworking(QString FCaption)
{
   buttonClose->setEnabled(true);
   buttonCancel->setEnabled(false);
   setCaption(FCaption);
}

void workdlg::errorworking()
{
   buttonClose->setEnabled(true);
   buttonCancel->setEnabled(false);
   setCaption("Error...");
}
#include "workdlg.moc"
