/***************************************************************************
 *   Copyright (C) 2004 by Marco Kraus                                     *
 *   marco@libsdl.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "xvidoptdialog.h"

XvidOptDialog::XvidOptDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
: XvidOptionsDialog(parent,name, modal,fl)
{
}

XvidOptDialog::~XvidOptDialog()
{
}

QString XvidOptDialog::getOptions(int pass)
{
   QString Opts;
   
   Opts=" -xvidencopts bitrate="+BitrateSpinBox->cleanText()+
             ":me_quality="+MotionSpinBox->cleanText();
   if (MpegBox->isChecked()) Opts+=":quant_type=mpeg";
   if (GreyBox->isChecked()) Opts+=":greyscale";
   if (FQBox->isChecked()) Opts+= ":fixed_quant="+FQSpinBox->cleanText();
   if (GMCBox->isChecked()) Opts+=":gmc";
   if (TrellisBox->isChecked()) Opts+=":trellis";
   if (AnimeBox->isChecked()) Opts+=":cartoon";
   if (ChromaBox->isChecked()) Opts+=":chroma_opt";
   if (AAspectBox->isChecked()) Opts+=":gmc";
   Opts+=":vhq="+QString::number(MSAComboBox->currentItem());
   if (pass != 0 ) Opts+=":pass="+QString::number(pass);
   return Opts;
}

void XvidOptDialog::FQEnabled()
{
   if ( FQBox->isChecked() )
      FQSpinBox->setEnabled(false);
   else
      FQSpinBox->setEnabled(true);
}
#include "xvidoptdialog.moc"

