/* config.c */

#include <Xm/Xm.h>
#include <Xm/ToggleB.h>
#include "globaldefs.h"
#include "config.h"
#include "keyboard.h"
#include "trace.h"

Widget	keyboardlabel, nextkeylabel, ignorecaseslabel, keytoplabel ;
Widget	filterlabel ;

void	ToggledKeytop(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmToggleButtonCallbackStruct	*state ;
{
    XmString	label ;

    if (app_data.show_keytop != state->set)	{
	app_data.show_keytop = state->set ;
	RedrawKeyboard(scrolledtext) ;
    }
    label = XmStringCreateSimple(app_data.show_keytop ?
				 " Show keytop symbols " :
				 " Don't show keytop symbols ") ;
    XtVaSetValues(keytoplabel, XmNlabelString, label, NULL) ;
    XmStringFree(label) ;
}

void	ToggledIgnoreCases(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmToggleButtonCallbackStruct	*state ;
{
    XmString	label ;

    app_data.ignore_cases = state->set ;
    RedrawKeyboard(scrolledtext) ;
    label = XmStringCreateSimple(app_data.ignore_cases ?
				 " Case insensitive " :
				 " Case sensitive ") ;
    XtVaSetValues(ignorecaseslabel, XmNlabelString, label, NULL) ;
    XmStringFree(label) ;
}

void	ToggledWordDisplay(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmToggleButtonCallbackStruct	*state ;
{
    app_data.word_display = state->set ;
    RedrawStats(scrolledtext) ;
}

void	ToggledKeyboard(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmToggleButtonCallbackStruct	*state ;
{
    XmString	label ;

    if ((app_data.emulated_keyboard = !app_data.emulated_keyboard)
	== Dvorak)	{
	e_tab = d_tab ;
	rowse = rowsd ;
	colse = colsd ;
    }
    else	{
	e_tab = q_tab ;
	rowse = rowsq ;
	colse = colsq ;
    }
    sprintf(buf, " Keyboard: %s ",
	    app_data.emulated_keyboard == Dvorak ? "Dvorak" : "Qwerty") ;
    label = XmStringCreateSimple(buf) ;
    XtVaSetValues(keyboardlabel, XmNlabelString, label, NULL) ;
    XmStringFree(label) ;

    ReinitStats(scrolledtext) ;
    RedrawKeyboard(scrolledtext) ;
}

void	ToggledShow(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmToggleButtonCallbackStruct	*state ;
{
    XmString	label ;

    app_data.show_next_key = state->set ;
    RedrawKeyboard(scrolledtext) ;
    label = XmStringCreateSimple(app_data.show_next_key ?
				 " Show next key " :
				 " Don't show next key ") ;
    XtVaSetValues(nextkeylabel, XmNlabelString, label, NULL) ;
    XmStringFree(label) ;
}
