/* filter.c */

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include "globaldefs.h"
#include "keyboard.h"
#include "text.h"
#include "filter.h"
#include "trace.h"
#include "utils.h"

void	Filter(w, scrolledtext, cbs)
Widget				w ;
Widget				scrolledtext ;
XmSelectionBoxCallbackStruct	*cbs ;
{
    char		c, *cp, *old, *new, ca[0x80], *chars ;
    char		*bow, *oldp, *newp ;
    int			oldc, newc ;
    XmString		label ;
    TextUserData	*textu = GetUserData(scrolledtext) ;

    if (!XmStringGetLtoR(cbs->value, charset, &old))
	return ;

    chars = XtMalloc(strlen(old)*2+1) ;
    oldp = old ;
    newp = chars ;
    while(*oldp )
	if (app_data.ignore_cases && isalpha(*oldp))	{
	    *newp++ = toupper(*oldp) ;
	    *newp++ = tolower(*oldp++) ;
	}
	else
	    *newp++ = *oldp++ ;
    *newp = '\0' ;
    XtFree(old) ;

    cp = ca ;
    for (c = ' ' ; c < 0x7f ; c++)
	if (!strchr(chars, c))
	    *cp++ = c ;
    *cp = '\0' ;
    XtFree(chars) ;

    old = textu->original ;
    new = XtMalloc(strlen(old)+1) ;
    oldc = newc = 0 ;

    newp = bow = new ;
    oldp = old ;
    while (*oldp)	{
	/* copy one word */
	while (!isspace(*oldp))
	    *newp++ = *oldp++ ;
	*newp = '\0';
	oldc++ ;
	/* note this ignores a word that is only one char long, "a" in
	   particular, because it seems to show up annoyingly often */
	if (strpbrk(bow, ca) || strlen(bow) < 2)	{
	    /* invalid word */
	    if (strlen(bow) < 2)	oldc-- ;
	    newp = bow ;
	    while (isspace(*oldp))	{
		/* try not to copy multiple spaces */
		if (*oldp == '\n' &&
		    (newp > new ? newp[-1] != '\n' : False))	{
		    *newp++ = *oldp++ ;
		    bow++ ;
		}
		else
		    oldp++ ;
	    }
	}
	else	{
	    /* valid word */
	    while (isspace(*oldp))
		*newp++ = *oldp++ ;
	    bow = newp ;
	    newc++ ;
	}
    }
    *newp = '\0' ;

    if (newp == new)
	Doerror(scrolledtext, "No words found.", NULL) ;
    else	{
	textu->isreading = True ;
	XmTextSetString(scrolledtext, new) ;
	textu->isreading = False ;

	if (textu->filtered)	{
	    XtFree(textu->filtered) ;
	}
	textu->filtered = new ;

	/* dirty */
	XmTextSetInsertionPosition(scrolledtext, 1) ;
	XmTextSetInsertionPosition(scrolledtext, 0) ;

	sprintf(buf, "Filter: %d/%d words ", newc, oldc) ;
	label = XmStringCreateSimple(buf) ;
	XtVaSetValues(filterlabel, XmNlabelString, label, NULL) ;
	XmStringFree(label) ;

	ReinitStats(scrolledtext) ;
	RedrawKeyboard(scrolledtext) ;
    }
}

void	Unfilter(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmPushButtonCallbackStruct	*state ;
{
    XmString		label ;
    TextUserData	*textu = GetUserData(scrolledtext) ;

    textu->isreading = True ;
    XmTextSetString(scrolledtext, textu->original) ;
    textu->isreading = False ;
    if (textu->filtered)	{
	XtFree(textu->filtered) ;
	textu->filtered = NULL ;
    }

    XmTextSetInsertionPosition(scrolledtext, 1) ;
    XmTextSetInsertionPosition(scrolledtext, 0) ;

    label = XmStringCreateSimple("Filter: off  ") ;
    XtVaSetValues(filterlabel, XmNlabelString, label, NULL) ;
    XmStringFree(label) ;

    ReinitStats(scrolledtext) ;
    RedrawKeyboard(scrolledtext) ;
}
