/* main.c --
 *
 * the "main" function for the kp.  Doesn't do anything more than take
 * care of resources and call other functions.
 */

#include <Xm/Xm.h>
#include <string.h>
#include "globaldefs.h"
#include "resources.h"
#include "keyboard.h"
#include "fileutils.h"
#include "utils.h"

String	fallbacks[] = {
    "*reverseVideo: false",
    "*exit.fontList: -*-courier-bold-r-*--14-*",
    "*name.fontList: -*-helvetica-bold-r-*--14-*",
    "*fontList: -*-courier-bold-r-*--12-*",
    "*DoubleClickInterval: 500",
    NULL
} ;

char	buf[BUFSIZ+1] ;

Boolean	physicalkeyboard ;
AppData	app_data ;

void		main(argc, argv)
Cardinal	argc ;
String		*argv ;
{
    Widget		toplevel ;
    Widget		scrolledtext ;
    XtAppContext	app ;
    char		*filename ;

    toplevel = XtVaAppInitialize(&app, "Kp", options, XtNumber(options),
	&argc, argv, fallbacks, NULL) ;

    if (argc > 1)
	if (argc > 2)	{
	    Usage() ;
	    exit(1) ;
	}
	else if (!strncmp(argv[1], "-h", 2))	{
	    Usage() ;
	    exit(0) ;
	}

    XtVaGetApplicationResources(toplevel, (XtPointer) &app_data,
	resources, XtNumber(resources), NULL) ;

/*    printf("ServerVendor: %s\n", ServerVendor(XtDisplay(toplevel))) ;*/
    scrolledtext = MakeKeyboard(toplevel) ;

    if (argc > 1)	{
	filename = XtNewString(argv[1]) ;
	if (ReadFile(scrolledtext, filename) == ERROR)
	    LoadInitScreen(toplevel, scrolledtext, NULL) ;
    }
    else
	LoadInitScreen(toplevel, scrolledtext, NULL) ;

    XtRealizeWidget(toplevel) ;
    XtAddEventHandler(toplevel, StructureNotifyMask, False,
	(XtEventHandler)FixSize, NULL) ;

    XtAppMainLoop(app) ;
}
