/* menus.c */

#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include "globaldefs.h"
#include "config.h"
#include "fileutils.h"
#include "filter.h"
#include "menus.h"
#include "keyboard.h"
#include "trace.h"
#include "utils.h"
#include "version.h"

#ifdef	_NO_PROTO
static void	confirm() ;
static void	doexit() ;
static void	help() ;
static void	about() ;
static void	filterdialog() ;
#else
static void	confirm(Widget, Widget, XmPushButtonCallbackStruct *) ;
static void	doexit(Widget) ;
static void	help(Widget, Widget) ;
static void	about(Widget, Widget) ;
static void	filterdialog(Widget, Widget, XmPushButtonCallbackStruct *) ;
#endif

/* returns a managed menubar */

Widget		CreateMenus(mainwindow, scrolledtext)
Widget		mainwindow, scrolledtext ;
{
    Widget	menubar, filemenu, optionmenu, helpmenu ;
    Widget	keyboardmenu ;
    Widget	filtermenu ;
    Widget	button ;
    XmString	label ;

    menubar = XmCreateMenuBar(mainwindow, "menubar", NULL, 0) ;

    /* The file menu */
    filemenu = XmCreatePulldownMenu(menubar, "filemenu", NULL, 0) ;
    label = XmStringCreateSimple("File") ;
    XtVaCreateManagedWidget("File", xmCascadeButtonWidgetClass, menubar,
	XmNlabelString, label, XmNsubMenuId, filemenu,
        XmNmnemonic, 'F', NULL) ;
    XmStringFree(label) ;

    /* Initial screen button */
    label = XmStringCreateSimple("Reload initial screen") ;
    button = XtVaCreateManagedWidget("initscreen",
	xmPushButtonWidgetClass, filemenu, XmNlabelString, label,
	XmNmnemonic, 'i', NULL) ;
    XtAddCallback(button, XmNactivateCallback,
	(XtCallbackProc)LoadInitScreen, scrolledtext) ;
    XmStringFree(label) ;

    /* Load file button */
    label = XmStringCreateSimple("Load file...") ;
    button = XtVaCreateManagedWidget("load", xmPushButtonWidgetClass,
        filemenu, XmNlabelString, label, XmNmnemonic, 'L', NULL) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)LoadFile,
	scrolledtext) ;
    XmStringFree(label) ;

    /* Reinitialize */
    label = XmStringCreateSimple("Reinitialize stats") ;
    button = XtVaCreateManagedWidget("reinit", xmPushButtonWidgetClass,
        filemenu, XmNlabelString, label, XmNmnemonic, 'R', NULL) ;
    XmStringFree(label) ;
    XtAddCallback(button, XmNactivateCallback,
	(XtCallbackProc)ReinitStats, NULL) ;

    /* Quit button */
    label = XmStringCreateSimple("Quit program") ;
    button = XtVaCreateManagedWidget("quit", xmPushButtonWidgetClass,
        filemenu, XmNlabelString, label, XmNmnemonic, 'Q', NULL) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)confirm,
	mainwindow) ;
    XmStringFree(label) ;

    /* The option menu */
    optionmenu = XmCreatePulldownMenu(menubar, "optionmenu", NULL, 0) ;
    label = XmStringCreateSimple("Options") ;
    XtVaCreateManagedWidget("Option", xmCascadeButtonWidgetClass, menubar,
	XmNlabelString, label, XmNsubMenuId, optionmenu,
	XmNmnemonic, 'O', NULL) ;
    XmStringFree(label) ;

    /* Filter */
    filtermenu = XmCreatePulldownMenu(optionmenu, "Filter", NULL, 0) ;
    label = XmStringCreateSimple("Filter") ;
    button = XtVaCreateManagedWidget("Filter", xmCascadeButtonWidgetClass,
	optionmenu, XmNlabelString, label, XmNsubMenuId, filtermenu,
	XmNmnemonic, 'F', NULL) ;
    XmStringFree(label) ;

    label = XmStringCreateSimple("Filter...") ;
    button = XtVaCreateManagedWidget("Filter", xmPushButtonWidgetClass,
	filtermenu, XmNlabelString, label, XmNmnemonic, 'F', NULL) ;
    XmStringFree(label) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)filterdialog,
	scrolledtext) ;

    label = XmStringCreateSimple("Unfilter") ;
    button = XtVaCreateManagedWidget("Unfilter", xmPushButtonWidgetClass,
	filtermenu, XmNlabelString, label, XmNmnemonic, 'U', NULL) ;
    XmStringFree(label) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)Unfilter,
	scrolledtext) ;

    /* Show keytop */
    label = XmStringCreateSimple("Show keytop") ;
    button = XtVaCreateManagedWidget("showkeytop",
	xmToggleButtonWidgetClass, optionmenu, XmNlabelString, label,
	XmNset, app_data.show_keytop, XmNmnemonic, 'S', NULL) ;
    XmStringFree(label) ;

    XtAddCallback(button, XmNvalueChangedCallback,
	(XtCallbackProc)ToggledKeytop, scrolledtext) ;

    /* Show next key */
    label = XmStringCreateSimple("Show next key") ;
    button = XtVaCreateManagedWidget("shownextkey",
	xmToggleButtonWidgetClass, optionmenu, XmNlabelString, label,
	XmNset, app_data.show_next_key, XmNmnemonic, 'n', NULL) ;
    XmStringFree(label) ;

    XtAddCallback(button, XmNvalueChangedCallback,
	(XtCallbackProc)ToggledShow, scrolledtext) ;

    /* Ignore cases */
    label = XmStringCreateSimple("Case insensitive") ;
    button = XtVaCreateManagedWidget("ignorecases",
	xmToggleButtonWidgetClass, optionmenu, XmNlabelString, label,
	XmNset, app_data.ignore_cases, XmNmnemonic, 'C', NULL) ;
    XmStringFree(label) ;

    XtAddCallback(button, XmNvalueChangedCallback,
	(XtCallbackProc)ToggledIgnoreCases, scrolledtext) ;

    /* Word/character display */
    label = XmStringCreateSimple("Word display") ;
    button = XtVaCreateManagedWidget("worddisplay",
	xmToggleButtonWidgetClass, optionmenu, XmNlabelString, label,
	XmNset, app_data.word_display, XmNmnemonic, 'W', NULL) ;
    XmStringFree(label) ;

    XtAddCallback(button, XmNvalueChangedCallback,
	(XtCallbackProc)ToggledWordDisplay, scrolledtext) ;

    /* Keyboard */
    keyboardmenu = XmCreatePulldownMenu(optionmenu, "Keyboard", NULL, 0) ;
    label = XmStringCreateSimple("Keyboard") ;
    button = XtVaCreateManagedWidget("Keyboard",
	xmCascadeButtonWidgetClass, optionmenu, XmNlabelString, label,
	XmNsubMenuId, keyboardmenu, XmNmnemonic, 'K', NULL) ;
    XmStringFree(label) ;

    label = XmStringCreateSimple("Qwerty") ;
    button = XtVaCreateManagedWidget("Qwerty", xmToggleButtonWidgetClass,
	keyboardmenu, XmNlabelString, label, XmNmnemonic, 'Q',
	XmNset, app_data.emulated_keyboard == Qwerty, NULL) ;
    XmStringFree(label) ;

    label = XmStringCreateSimple("Dvorak") ;
    button = XtVaCreateManagedWidget("Dvorak", xmToggleButtonWidgetClass,
	keyboardmenu, XmNlabelString, label, XmNmnemonic, 'D',
	XmNset, app_data.emulated_keyboard == Dvorak, NULL) ;
    XmStringFree(label) ;

    XtAddCallback(button, XmNvalueChangedCallback,
	(XtCallbackProc)ToggledKeyboard, scrolledtext) ;

    XtVaSetValues(keyboardmenu, XmNradioBehavior, True,
	XmNradioAlwaysOne, True, NULL) ;

    /* The help menu */
    helpmenu = XmCreatePulldownMenu(menubar, "helpmenu", NULL, 0) ;
    label = XmStringCreateSimple("Help") ;
    button = XtVaCreateManagedWidget("Help", xmCascadeButtonWidgetClass,
	menubar, XmNlabelString, label, XmNsubMenuId, helpmenu,
	XmNmnemonic, 'H', NULL) ;
    XtVaSetValues(menubar, XmNmenuHelpWidget, button, NULL) ;
    XmStringFree(label) ;

    label = XmStringCreateSimple("About") ;
    button = XtVaCreateManagedWidget("About", xmPushButtonWidgetClass,
	helpmenu, XmNlabelString, label, XmNmnemonic, 'A', NULL) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)about,
	mainwindow) ;
    XmStringFree(label) ;

    label = XmStringCreateSimple("Help") ;
    button = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass,
	helpmenu, XmNlabelString, label, XmNmnemonic, 'H', NULL) ;
    XmStringFree(label) ;
    XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)help,
	mainwindow) ;

    XtManageChild(menubar) ;

    return (menubar) ;
}

static void	confirm(w, parent, cbs)
Widget				w ;
Widget				parent ;
XmPushButtonCallbackStruct	*cbs ;
{
    Widget	dialog ;
    XmString	str ;

    dialog = XmCreateMessageDialog(parent, "confirmation", NULL, 0) ;
    str = XmStringCreateSimple("Do you really want to quit?") ;
    XtVaSetValues(dialog, XmNmessageString, str, NULL) ;
    XmStringFree(str) ;
    XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)doexit, NULL) ;
    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON)) ;
    str = XmStringCreateSimple("  Yes  ") ;
    XtVaSetValues(dialog, XmNokLabelString, str, NULL) ;
    XmStringFree(str) ;
    str = XmStringCreateSimple("No") ;
    XtVaSetValues(dialog, XmNcancelLabelString, str, NULL) ;
    XmStringFree(str) ;

    XtManageChild(dialog) ;
}

static void	doexit(w)
Widget w ;
{
    exit(0) ;
}

static void	help(w, parent)
Widget		w, parent ;
{
    static char *helpmessage =
	"This message describes the general function of KP and the ways the\n\
features without \"Help\" buttons work.\n\
Try the \"Help\" buttons on dialogs if you want to read a detailed\n\
description of that particular function.\n\n\
You are supposed to type the key that corresponds to the character\n\
that is at the cursor.  When the program is case-insensitive, you\n\
don't have to hold the shift key to type uppercase letters.  When\n\
it is case-sensitive, you are expected to type the shift key too.\n\n\
When the \"Show next key\" feature is enabled, you will see the next\n\
key you have to type in reverse-video.\n\n\
You can choose between Dvorak an qwerty keyboards.\n\n\
There is a \"Filter\" feature that allows you to specify keys you\n\
want to practice.  Refer to its \"Help\" button for more details.\n\n\
All the features mentioned above can be selected using the\n\
\"Options\" menu.\n\n\
You can load any text file using the \"Load file\" entry in the\n\
\"File\" menu.  Try some English document---manual pages (cat\n\
versions) are a good start.\n\n\
                   Enjoy!" ;

    errorstring = helpmessage ;
    Dohelp(w, parent) ;
}

#define ABOUT "Keyboard Practicer (KP)\nVer %d.%d (%s)\n\nAuthor: Satoshi Asami\n asami@cs.berkeley.edu\n asami@freebsd.org"

static void	about(w, parent)
Widget		w, parent ;
{
    static char *about = NULL ;
    if (!about)	{
	about = XtMalloc(strlen(ABOUT)+200) ;	/* Just to be sure */
	sprintf(about, ABOUT, MAJOR_VERSION, MINOR_VERSION, RELEASE_DATE) ;
    }
    errorstring = about ;
    Dohelp(w, parent) ;
}

static void	filterdialog(w, scrolledtext, state)
Widget				w ;
Widget				scrolledtext ;
XmPushButtonCallbackStruct	*state ;
{
    static Widget	dialog ;
    XmString		label1, label2, label3, label4 ;

    if (!dialog)	{
	dialog =
	    XmCreatePromptDialog(scrolledtext, "filter", NULL, 0) ;
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)Filter,
	    scrolledtext) ;
	XtAddCallback(dialog, XmNcancelCallback,
	    (XtCallbackProc)XtUnmanageChild, NULL) ;
	XtAddCallback(dialog, XmNhelpCallback, (XtCallbackProc)Dohelp,
	    dialog) ;
	label1 = XmStringCreateSimple("Enter characters to choose:") ;
	label2 = XmStringCreateSimple("OK") ;
	label3 = XmStringCreateSimple("Cancel") ;
	label4 = XmStringCreateSimple("Help") ;
	XtVaSetValues(dialog, XmNselectionLabelString, label1,
	    XmNokLabelString, label2, XmNcancelLabelString, label3,
	    XmNhelpLabelString, label4, NULL) ;
	XmStringFree(label1) ;
	XmStringFree(label2) ;
	XmStringFree(label3) ;
	XmStringFree(label4) ;
    }
    errorstring =
	"If you choose \"OK\", the program will display only words that are\ncomposed entirely from the characters you enter here.\n\"Unfilter\" (in the Options menu) will resume original contents.\n\nWhen the \"Case Insensitive\" option is set, both uppercase\nand lowercase versions are included.\n\nWe recommend you to begin with the home position keys." ;
    XtManageChild(dialog) ;
    XmProcessTraversal(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT),
		       XmTRAVERSE_CURRENT) ;
}
