/* resources.h */

#ifndef _resources_h_
#define _resources_h_

#include "globaldefs.h"

#define XkpNshowKeytop	"showKeytop"
#define XkpCShowKeytop	"ShowKeytop"
#define XkpNshowNextKey	"showNextKey"
#define XkpCShowNextKey	"ShowNextKey"
#define XkpNignoreCases	"ignoreCases"
#define XkpCIgnoreCases	"IgnoreCases"
#define XkpNwordDisplay	"wordDisplay"
#define XkpCWordDisplay	"WordDisplay"
#define XkpNphysicalKeyboard	"physicalKeyboard"
#define XkpCPhysicalKeyboard	"PhysicalKeyboard"
#define XkpNkeyboard	"keyboard"
#define XkpCKeyboard	"Keyboard"
#define XkpNvendor	"vendor"
#define XkpCVendor	"Vendor"

static	XtResource	resources[] = {
    {
	XkpNshowKeytop,
	XkpCShowKeytop,
	XmRBoolean,
	sizeof(Boolean),
	XtOffset(AppDataPtr, show_keytop),
	XmRImmediate,
	(XtPointer) True,
    },
    {
	XkpNshowNextKey,
	XkpCShowNextKey,
	XmRBoolean,
	sizeof(Boolean),
	XtOffset(AppDataPtr, show_next_key),
	XmRImmediate,
	(XtPointer) True,
    },
    {
	XkpNignoreCases,
	XkpCIgnoreCases,
	XmRBoolean,
	sizeof(Boolean),
	XtOffset(AppDataPtr, ignore_cases),
	XmRImmediate,
	(XtPointer) True,
    },
    {
	XkpNwordDisplay,
	XkpCWordDisplay,
	XmRBoolean,
	sizeof(Boolean),
	XtOffset(AppDataPtr, word_display),
	XmRImmediate,
	(XtPointer) True,
    },
    {
	XkpNphysicalKeyboard,
	XkpCPhysicalKeyboard,
	XmRString,
	sizeof(String),
	XtOffset(AppDataPtr, physical_keyboard),
	XmRString,
	(XtPointer) NULL,
    },
    {
	XkpNkeyboard,
	XkpCKeyboard,
	XmRBoolean,
	sizeof(Boolean),
	XtOffset(AppDataPtr, emulated_keyboard),
	XmRImmediate,
	(XtPointer) Dvorak,
    },
    {
	XkpNvendor,
	XkpCVendor,
	XmRString,
	sizeof(String),
	XtOffset(AppDataPtr, vendor),
	XmRString,
	(XtPointer) NULL,
    },
} ;

static XrmOptionDescRec options[] = {
    {"-showkeytop",	"*showKeytop", XrmoptionNoArg, "True"},
    {"-kt",		"*showKeytop", XrmoptionNoArg, "True"},
    {"+showkeytop",	"*showKeytop", XrmoptionNoArg, "False"},
    {"+kt",		"*showKeytop", XrmoptionNoArg, "False"},
    {"-shownextkey",	"*showNextKey", XrmoptionNoArg, "True"},
    {"-nk",		"*showNextKey", XrmoptionNoArg, "True"},
    {"+shownextkey",	"*showNextKey", XrmoptionNoArg, "False"},
    {"+nk",		"*showNextKey", XrmoptionNoArg, "False"},
    {"-ignorecases",	"*ignoreCases", XrmoptionNoArg, "True"},
    {"-ic",		"*ignoreCases", XrmoptionNoArg, "True"},
    {"+ignorecases",	"*ignoreCases", XrmoptionNoArg, "False"},
    {"+ic",		"*ignoreCases", XrmoptionNoArg, "False"},
    {"-physical",	"*physicalKeyboard", XrmoptionSepArg, NULL},
    {"-vendor",		"*vendor", XrmoptionSepArg, NULL},
    {"-dvorak",		"*keyboard", XrmoptionNoArg, "True"},
    {"-qwerty",		"*keyboard", XrmoptionNoArg, "False"},
} ;

#endif	/* _resources_h_ */
