#ifndef KCALLWIDGET_H_INCLUDED
#define KCALLWIDGET_H_INCLUDED

#include <qdialog.h>
#include <qptrdict.h>
#include <qevent.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <time.h>

#include "../dissipate2/sipuri.h"
#include "kphonebook.h"



class QLabel;
class QLineEdit;
class KComboBox;
class QPushButton;
class QTextEdit;
class SipUser;
class SipCall;
class SipCallMember;
class SipTransaction;
class CallAudio;
class IncomingCall;
class SipMessage;
class KSipAuthentication;
class KPhoneView;

class KCallTransfer : public QDialog
{
	Q_OBJECT
public:
	KCallTransfer( QWidget *parent = 0, const char *name = 0 );
	~KCallTransfer( void );

signals:
	void pleaseTransfer( const QString & );

protected slots:
	void slotOk( void );
	void slotCancel( void );

private:
	QLineEdit *touri;
	QPushButton *helpPushButton;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
};

class KPhoneView;
class KCallWidget : public QDialog
{
	Q_OBJECT
public:
	KCallWidget( KSipAuthentication *auth, 
			CallAudio *callaudio, 
			SipCall *initcall,
			KPhoneView *parent,
			const char *name = 0 );
	~KCallWidget( void );
	SipCall *getCall();
	void switchCall( SipCall *newcall );
	void setRemote( QString newremote );
	void clickDial( void );
	void clickHangup( void );
	void setHide( void );
	bool isHided( void ) const { return hided; }
	void KCallWidget::setDTMFSender( QString &s );

public slots:
	void pleaseDial( const SipUri &dialuri );

signals:
	void callDeleted( void );
	void redirectCall( const SipUri &calluri, const QString &subject );

private slots:
	void hangupCall( void );
	void dialClicked( void );
	void audioOutputDead( void );
	void acceptCall( void );
	void holdCall( void );
	void callMemberStatusUpdated( void );
	void updateAudioStatus( void );
	void handleRedirect( void );
	void handleRefer( void );
	void showTransferDialog( void );
	void pleaseTransfer( const QString &transferto );
	void getUri( void );
	void dtmfsenderChanged( const QString & );
	void dtmfsenderTimeout( void );
	void ringTimeout( void );
	void acceptCallTimeout( void );
	void hideCall( void );

protected slots:
	void keypadPressed( int id );
	void keypadReleased( int id );

private:
	QPtrList<IncomingCall> receivedCalls;
	QPtrList<IncomingCall> missedCalls;
	IncomingCall *incomingCall;
	void updateCallRegister( void );
	void createKeypad(void);

	// Sip Stuff
	SipCall *call;
	SipCallMember *member;
	KPhoneView *phoneView;
	KSipAuthentication *sipauthentication;

	// Audio Stuff
	CallAudio *audio;

	int ringCount;
	QTimer *ringTimer;
	bool isRingingTone;
	QTimer *acceptCallTimer;
	int audio_fd;
	QString subject;

	// DTMF Stuff
	QTimer *dtmfsenderTimer;

	// GUI Stuff
	QLabel *curstat;
	QLabel *curaudiostat;
	QPushButton *dial;
	QPushButton *hangup;
	QPushButton *holdbutton;
	QPushButton *transferbutton;
	QPushButton *morebutton;
	QPushButton *hidebutton;
	QComboBox *remote;
	QComboBox *dtmfsender;
	QSpinBox *dtmfsenderdelay;
	KCallTransfer *transfer;
	PhoneBook *phoneBook;
	bool hided;
	QButtonGroup* keypad;

	// State stuff
	enum CallState {
		PreDial,
		Calling,
		Connected,
		Called };
	CallState curstate;

	// Private functions
	void forceDisconnect( void );
	QString getUserPrefix( void );
};

class KInstantMessageWidget : public QDialog
{
	Q_OBJECT
public:
	KInstantMessageWidget( KSipAuthentication *auth,
		SipCall *initcall, QWidget *parent = 0, const char *name = 0 );
	~KInstantMessageWidget( void );
	void instantMessage( SipMessage *message );
	SipCall *getCall();
	QString getRemote();
	void setRemote( QString newremote );

private slots:
	void mClicked( void );
	void getUri( void );

private:
	QPtrList<IncomingCall> receivedCalls;
	QPtrList<IncomingCall> missedCalls;
	IncomingCall *incomingCall;

	// Sip Stuff
	SipCall *imcall;
	SipCallMember *member;
	KSipAuthentication *sipauthentication;

	// GUI Stuff
	QTextEdit *status;
	QTextEdit *mEdit;
	QPushButton *mbutton;
	QPushButton *qbutton;
	QPushButton *hidebutton;
	QComboBox *remote;
	KCallTransfer *transfer;
	PhoneBook *phoneBook;

	// Private functions
	QString getUserPrefix( void );
};


#endif // KCALLWIDGET_H_INCLUDED
