/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "card.h"
#include "cards.h"

#include <qevent.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpointarray.h>
#include <qrect.h>
#include <qtimer.h>

Card::Card(QWidget *parent, const char *name)
  : QWidget(parent, name, WPaintClever | WRepaintNoErase),
    m_pic(new QPixmap()),
    m_blinkTimer(new QTimer(this)),
    m_lbDown(false),
    m_border(1),
    m_cardNumber(-1),
    m_cEmpty(false),
    m_allowHighlight(true),
    m_blinkNumbers(0),
    m_blinkCount(0),
    m_marked(false),
    m_allowMark(true),
    m_color("black"),
    m_mColor("yellow"),
    m_mbColor("lightgrey"),
    m_bgColor("white")
{
  setFixedSize(76, 98);
  setBackgroundMode(NoBackground);

  setCardNumber(-1);

  connect(m_blinkTimer, SIGNAL(timeout()), SLOT(blinkTimerEvent()));
}


Card::~Card()
{
  delete m_blinkTimer;
  delete m_pic;
}

void Card::paintEvent(QPaintEvent *)
{
  if (!isVisible())
    return;

  int left, top, width, height;

  QPainter painter(this);
  if (m_cardNumber == back)
  {
    painter.drawPixmap(QPoint(0, 0), *m_pic);
    if (!m_cEmpty)
    {
      painter.setPen(QPen(black, 1, SolidLine));
      painter.drawLine(2, 93, 68, 93);
      painter.drawLine(69, 2, 69, 92);
      painter.drawPoint(69, 93);
    }

    left = 1; top = 1; height = 93; width = 69;
    QRegion qr(left, top, width, height);
    QRegion qr2(1, 1, 1, 1);
    qr = qr.eor(qr2);
    QRegion qr3(68, 93, 2, 1);
    qr = qr.eor(qr3);
    QRegion qr4(68, 1, 2, 1);
    qr = qr.eor(qr4);
    QRegion qr5(1, 92, 1, 2);
    qr = qr.eor(qr5);
    QRegion qr6(69, 91, 1, 2);
    qr = qr.eor(qr6);
    setMask(qr);
    return;
  }
  if ((m_border == 1) || m_marked)
  {
    if (m_marked)
      m_border = 1;

    QRect  *r1 = new QRect(3, 3, 71, 93);
    painter.setPen(QPen(m_bgColor, 2, SolidLine));
    painter.drawRect(*r1);
    delete r1;

    QRect  *r = new QRect(2, 2, 73, 95);
    painter.setPen(QPen(m_color, m_border, SolidLine));
    painter.drawRect(*r);
    delete r;

    QBrush *brush = new QBrush(m_bgColor);
    painter.fillRect(4, 4, 68, 90, *brush);
    delete brush;

    if (m_cardNumber != empty)
      painter.drawPixmap(QPoint(5, 6), *m_pic);

    left = 2; top = 2; height = 95; width = 73;
    QRegion qr (left, top, width, height);
    setMask(qr);
  }
  else
  {
    QRect  *r = new QRect(2, 2, 73, 95);
    painter.setPen(QPen(QColor("white"), m_border, SolidLine));
    painter.drawRect(*r);
    delete r;

    painter.setPen(QPen(QColor("darkgray"), 1, SolidLine));
    painter.drawLine(2, 1, 73, 1);
    painter.drawLine(1, 2, 1, 96);
    painter.setPen(QPen(m_color, 2, SolidLine));
    painter.drawLine(3, 96, 73, 96);
    painter.drawLine(74, 3, 74, 95);
    painter.setPen(QPen(m_color, 1, SolidLine));
    painter.drawPoint(2, 95);
    painter.drawPoint(73, 95);
    painter.drawPoint(73, 2);

    QBrush *brush = new QBrush(m_bgColor);
    painter.fillRect(4, 4, 68, 90, *brush);
    delete brush;

    if (m_cardNumber != empty)
      painter.drawPixmap(QPoint(4, 5), *m_pic);

    left = 1; top = 1; height = 96; width = 74;
    QRegion qr (left, top, width, height);
    QRegion qr2(1,1,1,1);
    qr = qr.eor(qr2);
    QRegion qr3(74,95,1,2);
    qr = qr.eor(qr3);
    QRegion qr4(73,1,2,1);
    qr = qr.eor(qr4);
    QRegion qr5(1,96,1,2);
    qr = qr.eor(qr5);
    QRegion qr6(73,96,1,1);
    qr = qr.eor(qr6);
    QRegion qr7(74,2,1,1);
    qr = qr.eor(qr7);
    QRegion qr8(2,96,1,1);
    qr = qr.eor(qr8);
    setMask(qr);
  }
}

void Card::enterEvent(QEvent *)
{
  highlightField(true);
}

void Card::leaveEvent(QEvent *)
{
  highlightField(false);
}

void Card::mouseMoveEvent(QMouseEvent * e)
{
}

void Card::mousePressEvent(QMouseEvent *e)
{
  if (e->button() != LeftButton)
    return;

  bool hit = inCard(e->pos());

  if (hit) // mouse press on card
  {
    m_lbDown = true;  // remember: mouse press on card
    //dragOffset = e->Pos();
    emit pressed(this);
  }
}

void Card::mouseReleaseEvent(QMouseEvent *e)
{
  if (e->button() != LeftButton)
    return;

  if (inCard(e->pos()))
  { // mouse release on card
    emit released(this);
    if (m_lbDown)
      emit clicked(this);
  }
  m_lbDown = false;// mouse up
}

bool Card::inCard( const QPoint &pos ) const
{
  return rect().contains(pos);
}

int Card::getValue()
{
  if ((m_cardNumber > 48) && (m_cardNumber < 53))
    return 1;
  if ((m_cardNumber > 0) && (m_cardNumber < 5))
    return 2;
  if ((m_cardNumber > 4) && (m_cardNumber < 9))
    return 3;
  if ((m_cardNumber > 8) && (m_cardNumber < 13))
    return 4;
  if ((m_cardNumber > 12) && (m_cardNumber < 17))
    return 5;
  if ((m_cardNumber > 16) && (m_cardNumber < 21))
    return 6;
  if ((m_cardNumber > 20) && (m_cardNumber < 25))
    return 7;
  if ((m_cardNumber > 24) && (m_cardNumber < 29))
    return 8;
  if ((m_cardNumber > 28) && (m_cardNumber < 33))
    return 9;
  if ((m_cardNumber > 32) && (m_cardNumber < 37))
    return 10;

  return -1;
}

void Card::setMBColor(const QColor & color)
{
  m_mbColor = color;
}

void Card::setMColor(const QColor & color)
{
  m_mColor = color;
}

const QColor& Card::getMBColor()
{
  return m_mbColor;
}

const QColor& Card::getMColor()
{
  return m_mColor;
}

bool Card::isMarked()
{
  return m_marked;
}

bool Card::enableMarking(bool state)
{
  if (m_marked)
    m_allowMark = true;
  else
    m_allowMark = state;

  return m_allowMark;
}

bool Card::enableHighlightning(bool state)
{
  m_allowHighlight = state;

  if (!state)
    m_border = 1;

  return m_allowHighlight;
}

bool Card::markField(bool state)
{
  if (!m_allowMark)
    return false;

  m_marked = state;
  m_border = 1;

  if (m_marked)
  {
    m_color   = m_mColor;
    m_bgColor = m_mbColor;
  }
  else
  {
    m_color   = QColor(black);
    m_bgColor = QColor(white);
  }

  update();

  return m_marked;
}

void Card::highlightField(bool state)
{
  if (!m_allowHighlight)
    return;

  if (state == true)
    m_border = 2;
  else
  {
    if (!m_marked)
      m_border = 1;
    else
      m_border = 2;
  }

  update();
}

bool Card::setCardNumber(int number)
{
  QPixmap *pm;
  switch (number)
  {
    case empty:
      //setBackgroundColor(QColor(white));
     pm = new QPixmap( *pempty);
     break;

    case back:
     pm = new QPixmap( pback);
     break;

    case club2:
     pm = new QPixmap( pclub2);
     break;

    case club3:
     pm = new QPixmap( pclub3);
     break;

    case club4:
      pm = new QPixmap( pclub4);
      break;
     case club5:
      pm = new QPixmap( pclub5);
      break;
    case club6:
      pm = new QPixmap( pclub6);
      break;
    case club7:
      pm = new QPixmap( pclub7);
      break;
    case club8:
      pm = new QPixmap( pclub8);
      break;
    case club9:
      pm = new QPixmap( pclub9);
      break;
    case club10:
      pm = new QPixmap( pclub10);
      break;
    case clubJack:
      pm = new QPixmap( pclubjack);
      break;
    case clubQueen:
      pm = new QPixmap( pclubqueen);
      break;
    case clubKing:
      pm = new QPixmap( pclubking);
      break;
    case clubAce:
      pm = new QPixmap( pclubace);
      break;
    case diamond2:
      pm = new QPixmap( pdiamond2);
      break;
    case diamond3:
      pm = new QPixmap( pdiamond3);
      break;
    case diamond4:
      pm = new QPixmap( pdiamond4);
      break;
     case diamond5:
      pm = new QPixmap( pdiamond5);
      break;
    case diamond6:
      pm = new QPixmap( pdiamond6);
      break;
    case diamond7:
      pm = new QPixmap( pdiamond7);
      break;
    case diamond8:
      pm = new QPixmap( pdiamond8);
      break;
    case diamond9:
      pm = new QPixmap( pdiamond9);
      break;
    case diamond10:
      pm = new QPixmap( pdiamond10);
      break;
    case diamondJack:
      pm = new QPixmap( pdiamondjack);
      break;
    case diamondQueen:
      pm = new QPixmap( pdiamondqueen);
      break;
    case diamondKing:
      pm = new QPixmap( pdiamondking);
      break;
    case diamondAce:
      pm = new QPixmap( pdiamondace);
      break;
    case hearts2:
      pm = new QPixmap( phearts2);
      break;
    case hearts3:
      pm = new QPixmap( phearts3);
      break;
    case hearts4:
      pm = new QPixmap( phearts4);
      break;
     case hearts5:
      pm = new QPixmap( phearts5);
      break;
    case hearts6:
      pm = new QPixmap( phearts6);
      break;
    case hearts7:
      pm = new QPixmap( phearts7);
      break;
    case hearts8:
      pm = new QPixmap( phearts8);
      break;
    case hearts9:
      pm = new QPixmap( phearts9);
      break;
    case hearts10:
      pm = new QPixmap( phearts10);
      break;
    case heartsJack:
      pm = new QPixmap( pheartsjack);
      break;
    case heartsQueen:
      pm = new QPixmap( pheartsqueen);
      break;
     case heartsKing:
      pm = new QPixmap( pheartsking);
      break;
    case heartsAce:
      pm = new QPixmap( pheartsace);
      break;
    case spades2:
      pm = new QPixmap( pspades2);
      break;
    case spades3:
      pm = new QPixmap( pspades3);
      break;
    case spades4:
      pm = new QPixmap( pspades4);
      break;
    case spades5:
      pm = new QPixmap( pspades5);
      break;
    case spades6:
      pm = new QPixmap( pspades6);
      break;
    case spades7:
      pm = new QPixmap( pspades7);
      break;
    case spades8:
      pm = new QPixmap( pspades8);
      break;
    case spades9:
      pm = new QPixmap( pspades9);
      break;
    case spades10:
      pm = new QPixmap( pspades10);
      break;
    case spadesJack:
      pm = new QPixmap( pspadesjack);
      break;
    case spadesQueen:
      pm = new QPixmap( pspadesqueen);
      break;
     case spadesKing:
      pm = new QPixmap( pspadesking);
      break;
    case spadesAce:
      pm = new QPixmap( pspadesace);
      break;

    default:
      return false;
  }

  *m_pic = *pm;
  m_cardNumber = number;
  m_cEmpty = false;
  update();
  delete pm;
  return true;
}

int Card::getCardNumber()
{
  return m_cardNumber;
}

void Card::setPos(int left, int top)
{
  setGeometry(left, top, 76, 98);
}

void Card::startBlink(int count)
{
  count *= 2;
  m_blinkTimer->start(500);

  if (count > 0)
    m_blinkNumbers = count;
  else
    m_blinkNumbers = 1;

  m_blinkCount = 0;
  m_marked     = false;
}

void Card::stopBlink()
{
  if (m_blinkTimer->isActive())
    m_blinkTimer->stop();

  m_border = 1;

  if (isMarked())
    markField(false);
}

void Card::blinkTimerEvent()
{
  if (m_blinkCount >= m_blinkNumbers)
  {
    stopBlink();
    return;
  }

  if (isMarked())
  {
    m_border = 1;
    markField(false);
  }
  else
  {
    m_border = 1;
    markField(true);
  }

  ++m_blinkCount;
}

void Card::setEmpty(bool state)
{
  m_cEmpty = state;
}

#include "card.moc"
