/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KCARD_H
#define KCARD_H

#define empty      -1
#define back        0
#define spades2     1
#define hearts2     2
#define diamond2    3
#define club2       4
#define spades3     5
#define hearts3     6
#define diamond3    7
#define club3       8
#define spades4     9
#define hearts4    10
#define diamond4   11
#define club4      12
#define spades5    13
#define hearts5    14
#define diamond5   15
#define club5      16
#define spades6    17
#define hearts6    18
#define diamond6   19
#define club6      20
#define spades7    21
#define hearts7    22
#define diamond7   23
#define club7      24
#define spades8    25
#define hearts8    26
#define diamond8   27
#define club8      28
#define spades9    29
#define hearts9    30
#define diamond9   31
#define club9      32
#define spades10   33
#define hearts10   34
#define diamond10  35
#define club10     36
#define spadesJack 37
#define heartsJack 38
#define diamondJack  39
#define clubJack     40
#define spadesQueen  41
#define heartsQueen  42
#define diamondQueen 43
#define clubQueen    44
#define spadesKing   45
#define heartsKing   46
#define diamondKing  47
#define clubKing     48
#define spadesAce    49
#define heartsAce    50
#define diamondAce   51
#define clubAce      52

#include <qpoint.h>
#include <qwidget.h>

class QPixmap;
class QEvent;
class QTimer;

class KCard : public QWidget
{
  Q_OBJECT
 public:
  KCard(QWidget *parent = 0, const char *name = 0);
  ~KCard();

  bool enableMarking(bool state);
  bool enableHighlightning(bool state);

  void setMBColor(const QColor & color);
  void setMColor(const QColor& color);

  const QColor & getMBColor();
  const QColor & getMColor();

  /** sets the card identification number*/
  bool setCardNumber(int number);
  /** gets the card identification number*/
  int  getCardNumber();

  void setPos(int left, int top);
  bool markField(bool state);

  void setEmpty(bool state);
  bool isMarked();
  int getValue();

  void startBlink(int count);
  void stopBlink();

  void highlightField(bool state);
  bool inCard( const QPoint & pos ) const; // is the point in the widgets area

 signals:
  void clicked(KCard*);
  void pressed(KCard*);
  void released(KCard*);

 protected:
  void paintEvent(QPaintEvent *);
  virtual bool eventFilter(QObject* object, QEvent* event);
  void mousePressEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent * e);

 protected slots:
  void blinkTimerEvent();

 private:
  QPixmap * m_pic;
  QTimer  * m_blinkTimer;

  bool m_lbDown;
  int  m_border;

  /** card identification number*/
  int  m_cardNumber;
  bool m_cEmpty;
  bool m_allowHighlight;
  int  m_blinkNumbers;
  int  m_blinkCount;

  QPoint m_dragStartPos;
  bool   m_marked;   // is the Card marked or not?
  bool   m_allowMark;// may the Card be marked?
  QColor m_color;  // color of the border
  QColor m_bColor;
  QColor m_mColor; // color of the border if the card is marked
  QColor m_mbColor;
  QColor m_bgColor;// color of the background
};

#endif
