/*
 * Copyright (C) 2004 Norbert Andres <nandres@web.de>
 */

#include "kpicframer.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A small (but sligthly maddening) card game");

static const char version[] = "0.5";

int main(int argc, char **argv)
{
    KAboutData about("kpicframer", I18N_NOOP("KPicFramer"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Norbert Andres", 0, 0,
                     "nandres@web.de");
    about.addAuthor( "Norbert Andres", 0, "nandres@web.de" );
    KCmdLineArgs::init(argc, argv, &about);
    KApplication app;

    // see if we are starting with session management
    if (app.isRestored())
    {
      RESTORE(KPicFramer);
    }
    else
    {
      KPicFramer * widget = new KPicFramer();
      widget->show();
    }

    return app.exec();
}
