/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "options.h"

#include <kconfig.h>

  Options::Options(KConfig * config)
    : m_highScore(0),
      m_lostGames(0),
      m_stoppedGames(0),
      m_wonGames(0),
      m_lastScore(0),
      m_animationSpeed(20),
      m_setBackground(true),
      m_showAnimations(true),
      m_backgroundColor("#9898f3"),
      m_highlightColor("#ffff00"),
      m_blinkColor("#d3d3d3"),
      m_counterBgColor("#99cc00"),
      m_counterFgColor("#ffff00")
  {
    if (config)
      readConfig(config);
  }

  Options::~Options()
  {
  }

  void Options::readConfig(KConfig * config)
  {
    if (!config)
      return;

    config->setGroup("Statistic");

    m_highScore       = config->readNumEntry("HighScore",    0);
    m_lostGames       = config->readNumEntry("lostGames",    0);
    m_stoppedGames    = config->readNumEntry("stoppedGames", 0);
    m_wonGames        = config->readNumEntry("wonGames",     0);
    m_lastScore       = config->readNumEntry("lastScore",    0);

    config->setGroup("Others");
    m_animationSpeed  = config->readNumEntry("Animationspeed",     m_animationSpeed);
    m_setBackground   = config->readBoolEntry("setBackground",     m_setBackground);
    m_showAnimations  = config->readBoolEntry("Animations",        m_showAnimations);

    config->setGroup("Colors");
    m_backgroundColor = QColor(config->readEntry("BgColor",        m_backgroundColor.name()));
    m_highlightColor  = QColor(config->readEntry("HlColor",        m_highlightColor.name()));
    m_blinkColor      = QColor(config->readEntry("BlinkColor",     m_blinkColor.name()));
    m_counterBgColor  = QColor(config->readEntry("CounterBgColor", m_counterBgColor.name()));
    m_counterFgColor  = QColor(config->readEntry("CounterFgColor", m_counterFgColor.name()));
  }

  void Options::writeConfig(KConfig * config)
  {
    if (!config)
      return;

    config->setGroup("Statistic");
    config->writeEntry("wonGames",       m_wonGames);
    config->writeEntry("lostGames",      m_lostGames);
    config->writeEntry("stoppedGames",   m_stoppedGames);
    config->writeEntry("HighScore",      m_highScore);
    config->writeEntry("lastScore",      m_lastScore);

    config->setGroup("Others");
    config->writeEntry("Animationspeed", m_animationSpeed);
    config->writeEntry("setBackground",  m_setBackground);
    config->writeEntry("Animations",     m_showAnimations);

    config->setGroup("Colors");
    config->writeEntry("BgColor",        m_backgroundColor.name());
    config->writeEntry("HlColor",        m_highlightColor.name());
    config->writeEntry("BlinkColor",     m_blinkColor.name());
    config->writeEntry("CounterBgColor", m_counterBgColor.name());
    config->writeEntry("CounterFgColor", m_counterFgColor.name());
  }

  void Options::setHighscore(int score)
  {
    m_highScore = score;
  }

  void Options::setLostGames(int lost)
  {
    m_lostGames = lost;
  }

  void Options::setStoppedGames(int stopped)
  {
    m_stoppedGames = stopped;
  }

  void Options::setWonGames(int won)
  {
    m_wonGames = won;
  }

  void Options::setLastScore(int score)
  {
    m_lastScore = score;
  }

  void Options::setAnimationSpeed(int speed)
  {
    m_animationSpeed = speed;
  }

  void Options::showAnimations(bool show)
  {
    m_showAnimations = show;
  }

  void Options::setBackground(bool setBg)
  {
    m_setBackground = setBg;
  }

  void Options::setBgColor(QColor const & color)
  {
    m_backgroundColor = color;
  }

  void Options::setHlColor(QColor const & color)
  {
    m_highlightColor = color;
  }

  void Options::setBlinkColor(QColor const & color)
  {
    m_blinkColor = color;
  }

  void Options::setCounterBgColor(QColor const & color)
  {
    m_counterBgColor = color;
  }

  void Options::setCounterFgColor(QColor const & color)
  {
    m_counterFgColor = color;
  }

