/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "colorframe.h"
#include "miscframe.h"
#include "options.h"
#include "prefs.h"

#include <kcolorbutton.h>
#include <kiconloader.h>
#include <knuminput.h>
#include <klocale.h>

#include <qcheckbox.h>
#include <qlayout.h>
#include <qlabel.h>

KPicPreferences::KPicPreferences(Options * options)
  : KDialogBase(IconList, i18n("KPicFramer Preferences"),
                Help | Default | Ok | Apply | Cancel, Ok),
    m_options(options)
{
  // this is the base class for your preferences dialog.  it is now
  // a Treelist dialog.. but there are a number of other
  // possibilities (including Tab, Swallow, and just Plain)
  QFrame * frame = addPage(i18n("Colors"), i18n("Color Settings"),
                           BarIcon("colorize", KIcon::SizeMedium));

  QVBoxLayout * layout = new QVBoxLayout(frame, 0, KDialog::spacingHint());
  m_colorPage = new ColorPage(frame);
  layout->addWidget(m_colorPage);

  frame = addPage(i18n("Miscellaneous"), i18n("Miscellaneous Settings"),
                  BarIcon("gear", KIcon::SizeMedium));
  layout = new QVBoxLayout(frame, 0, KDialog::spacingHint());
  m_miscPage = new MiscPage(frame);
  layout->addWidget(m_miscPage);

  initOptions(options);
}

void KPicPreferences::initOptions(Options * options)
{
  if (!options)
    return;

  m_colorPage->m_color->m_setBackground->setChecked(options->setBackground());
  m_colorPage->m_color->m_counterBg->setColor(options->getCounterBgColor());
  m_colorPage->m_color->m_counterFg->setColor(options->getCounterFgColor());
  m_colorPage->m_color->m_highlight->setColor(options->getHlColor());
  m_colorPage->m_color->m_blink->setColor(options->getBlinkColor());
  m_colorPage->m_color->m_background->setColor(options->getBgColor());

  m_colorPage->m_color->m_background->setEnabled(options->setBackground());

  m_miscPage->m_misc->m_animationSpeed->setValue(options->getAnimationSpeed());
  m_miscPage->m_misc->m_showAnimations->setChecked(options->showAnimations());

  m_miscPage->m_misc->m_animationSpeed->setEnabled(options->showAnimations());
}

void KPicPreferences::setOptions()
{
  if (!m_options)
    return;

  m_options->setAnimationSpeed(m_miscPage->m_misc->m_animationSpeed->value());
  m_options->showAnimations(m_miscPage->m_misc->m_showAnimations->isChecked());

  m_options->setBackground(m_colorPage->m_color->m_setBackground->isChecked());
  m_options->setBgColor(m_colorPage->m_color->m_background->color());
  m_options->setBlinkColor(m_colorPage->m_color->m_blink->color());
  m_options->setHlColor(m_colorPage->m_color->m_highlight->color());
  m_options->setCounterBgColor(m_colorPage->m_color->m_counterBg->color());
  m_options->setCounterFgColor(m_colorPage->m_color->m_counterFg->color());

  emit saveConfig();
}

void KPicPreferences::slotApply()
{
  setOptions();
}

void KPicPreferences::slotOk()
{
  setOptions();
  accept();
}

void KPicPreferences::slotDefault()
{
  Options * options = new Options(0);
  initOptions(options);
  delete options;
}


ColorPage::ColorPage(QWidget *parent)
  : QFrame(parent)
{
  QVBoxLayout * layout = new QVBoxLayout(this, 0, KDialog::spacingHint());
  layout->setResizeMode(QLayout::Minimum);

  m_color = new ColorWidget(this);
  layout->addWidget(m_color);

  connect(m_color->m_setBackground, SIGNAL(toggled(bool)), this, SLOT(slotShowBackground(bool)));
}

void ColorPage::slotShowBackground(bool on)
{
  m_color->m_background->setEnabled(on);
}

MiscPage::MiscPage(QWidget *parent)
  : QFrame(parent)
{
  QVBoxLayout *layout = new QVBoxLayout(this);
  layout->setAutoAdd(true);
  layout->setResizeMode(QLayout::Minimum);

  m_misc = new MiscWidget(this);
  connect(m_misc->m_showAnimations, SIGNAL(toggled(bool)), this, SLOT(slotShowAnimations(bool)));
}

void MiscPage::slotShowAnimations(bool on)
{
  m_misc->m_animationSpeed->setEnabled(on);
}

#include "prefs.moc"
