/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KPICFRAMER_H_
#define _KPICFRAMER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "options.h"

#include <kapplication.h>
#include <kmainwindow.h>

class KToggleAction;
class KPicFramerView;

class KPicFramer : public KMainWindow
{
    Q_OBJECT
public:
    KPicFramer();
    virtual ~KPicFramer();

    Options * options() { return m_options; }

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);
    bool queryClose();

private slots:
    void newGame();
    void pauseGame();
    void restartGame();
    void undo();

    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void optionsSave();

    void newToolbarConfig();
    void showHighscore();
    void enableUndo(bool enable);

    void changeStatusbar(const QString& text);
    void changeScore(int score);
    void changeCaption(const QString& text);

    void changeStoppedGames(int score);
    void changeWonGames(int score);
    void changeLostGames(int score, int num);
    void showGameOver(const QString & title);

private:
    void setupActions();
    void checkHighscore(int score);

    Options         * m_options;
    KPicFramerView  * m_view;

    KToggleAction   * m_toolbarAction;
    KToggleAction   * m_statusbarAction;
    KToggleAction   * m_pauseAction;
    KAction         * m_newAction;
    KAction         * m_undoAction;
    KAction         * m_restartAction;
};

#endif // _KPICFRAMER_H_
