/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KPICFRAMERVIEW_H_
#define _KPICFRAMERVIEW_H_

#include <qwidget.h>

class Card;
class QFrame;
class QLabel;
class QResizeEvent;
class QTimer;

class KPicFramerView : public QWidget
{
  Q_OBJECT
 public:
  typedef enum { gameOver, layDown, pickUp } playPhase;

  KPicFramerView(QWidget *parent);
  virtual ~KPicFramerView();

  void reinit();
  void newGame();
  void undo();
  bool pause();
  void restart();
  bool close();

 signals:
  void signalChangeStatusbar(const QString& text);
  void signalChangeCaption(const QString& text);
  void signalChangeScore(int number);
  void signalIncreaseStoppedGames(int score);
  void signalIncreaseWonGames(int score);
  void signalIncreaseLostGames(int num, int score);
  void signalGameOver(const QString & title);
  void signalEnableUndo(bool enable);
  void signalPauseEnd();

 private:

  playPhase m_phase;
  playPhase m_backupPhase;

  /** counts how many fields are marked  */
  int  m_mcount;
  bool m_dragging;
  bool m_moving;
  int  m_backupField[16];
  int  m_backupIndex;
  int  m_backupACard;
  int  m_lastField;
  int  m_mindex1;  // index of the first marked card
  int  m_mindex2;  // index of the second marked card

  int  m_score;
  int  m_cStack[52]; // card stack
  int  m_cardIndex;  // current index on stack
  int  m_aniCount;
  Card * m_stack;
  Card * m_activeCard;
  Card * m_cards[16]; // play field
  Card * m_aCard;

  QLabel * m_lCounter;
  QTimer * m_scoreTimer;
  QTimer * m_wonAniTimer;
  QTimer * m_cardAniTimer;

  QLabel * m_lMessage;
  QLabel * m_lText;
  QLabel * m_panel;
  QLabel * m_lScore;
  QLabel * m_lHighScore;

  QFrame * m_frameLeft;
  QFrame * m_frameRight;

  int m_undoItem;
/*  int m_pauseItem;
  int m_continueItem;*/
  int m_animationItem;
  int m_backgroundItem;

/*
                int animationSpeed;
                bool boolAnimations;

    int lostGames;
    int wonGames;
    int stoppedGames;
    int highScore;
                QStringList bColors;
                int backgroundColorIndex;
*/

  void cleanup();

  void initCards();
  void initPlayField();

  void setPhase(playPhase p);
  int  getFieldIndex(Card * card);
  bool layDownCard(Card * card);
  bool finishLayDown();
  bool pickUpCard(Card * card);
  int  getSum();
  void newCard();
  bool cardTest(Card * card, int actCardNumber);
  int  emptyFieldsCount();

  bool stopCurrentGame();
  bool gameLost();
  void changeScore(int number);
  bool queryClose();
  bool pickupPossible();
  bool picFrameReady();
  void createFrame();
  void lost();
  void won();
  void wonAnimation(int speed);
  void cardAnimation(int x, int y, int speed);

 private slots:
  void scoreTimerEvent();
  void wonAniTimerEvent();
  void cardAniTimerEvent();

  void cardClicked(Card *);
  void nextCard(Card *);
  void startDrag(Card *);
  void endDrag(Card *);


//   void showAnimations();
//   void changeSpeed(int);
//   void changeBackgroundColor(int);

};

#endif // _KPICFRAMERVIEW_H_
