/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KPICFRAMEROPTIONS_H
#define KPICFRAMEROPTIONS_H

class KConfig;

#include <qcolor.h>

  class Options
  {
   public:
    typedef enum { Stopped, Won, Highscore, Lost } Value;
    Options(KConfig * config);
    ~Options();

    void readConfig(KConfig * config);
    void writeConfig(KConfig * config);

    void setHighscore(int score);
    void setLostGames(int lost);
    void setStoppedGames(int stopped);
    void setWonGames(int won);
    void setLastScore(int score);

    void setAnimationSpeed(int speed);
    void showAnimations(bool show);
    void setBackground(bool setBg);

    void setBgColor(QColor const & color);
    void setHlColor(QColor const & color);
    void setBlinkColor(QColor const & color);
    void setCounterBgColor(QColor const & color);
    void setCounterFgColor(QColor const & color);

    int  getHightScore() const           { return m_highScore; }
    int  getLostGames() const            { return m_lostGames; }
    int  getStoppedGames() const         { return m_stoppedGames; }
    int  getWonGames() const             { return m_wonGames;  }
    int  getLastScore() const            { return m_lastScore; }

    int  getAnimationSpeed() const       { return m_animationSpeed; }
    bool showAnimations() const          { return m_showAnimations; }
    bool setBackground() const           { return m_setBackground;  }

    QColor const & getBgColor() const    { return m_backgroundColor; }
    QColor const & getHlColor() const    { return m_highlightColor; }
    QColor const & getBlinkColor() const { return m_blinkColor;   }
    QColor const & getCounterBgColor() const { return m_counterBgColor; }
    QColor const & getCounterFgColor() const { return m_counterFgColor; }

   private:
    int    m_highScore;
    int    m_lostGames;
    int    m_stoppedGames;
    int    m_wonGames;
    int    m_lastScore;

    int    m_animationSpeed;
    bool   m_setBackground;
    bool   m_showAnimations;

    QColor m_backgroundColor;
    QColor m_highlightColor;
    QColor m_blinkColor;
    QColor m_counterBgColor;
    QColor m_counterFgColor;
  };


#endif
