/***************************************************************************
 *   Copyright (C) 2004 by Norbert Andres                                  *
 *   nandres@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KPICPREF_H_
#define _KPICPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

class ColorPage;
class ColorWidget;
class MiscPage;
class MiscWidget;
class Options;

class KPicPreferences : public KDialogBase
{
  Q_OBJECT

 public:
  KPicPreferences(Options * options);

 signals:
  void saveConfig();

 protected slots:
  void slotApply();
  void slotOk();
  void slotDefault();

 private:
  ColorPage * m_colorPage;
  MiscPage  * m_miscPage;
  Options   * m_options;

  void initOptions(Options * options);
  void setOptions();
};

class ColorPage : public QFrame
{
  Q_OBJECT

 public:
  ColorPage(QWidget * parent = 0);
  ColorWidget * m_color;

 private slots:
  void slotShowBackground(bool on);
};

class MiscPage : public QFrame
{
  Q_OBJECT

 public:
  MiscPage(QWidget * parent = 0);
  MiscWidget * m_misc;

 private slots:
  void slotShowAnimations(bool on);
};

#endif
