/***************************************************************************
                          kpopup.cpp  -  description
                             -------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include <kiconloader.h>
#include <klocale.h>
#include <ksystemtray.h>
#include <ktoolbarbutton.h>

#include <qtimer.h>

#include "kpopup.h"
#include "make_popup.h"
#include "misc.h"
#include "resource.h"

/*
 * constructor of Kpopup
 */
Kpopup::Kpopup() {

    actual = 0;

    setMinimumSize(282, 260);
    setMaximumSize(282, 260);

    init();
    initToolbar();
    initStatusbar();

    toolbar -> show();
    statusbar -> show();
    addToolBar(toolbar);

    setStatusText(i18n("Welcome to KPopup ") + QString(VERSION));
    timer -> start(3000, TRUE);

    tray = new KSystemTray(this);
    tray -> setPixmap(kapp -> miniIcon());
    tray -> show();

    lbl_Sender = new QLabel(i18n("Popup from:"), this);
    lbl_Sender -> setGeometry(12, 38, 88, 20);
    lbl_Sender -> setAlignment(AlignTop | AlignLeft);

    lbl_SenderValue = new QLabel("", this);
    lbl_SenderValue -> setGeometry(90, 35, 180, 20);
    lbl_SenderValue -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbl_SenderValue -> setAlignment(AlignTop | AlignLeft);

    lbl_DateTime = new QLabel(i18n("Popup time:"), this);
    lbl_DateTime -> setGeometry(12, 63, 88, 20);
    lbl_DateTime -> setAlignment(AlignTop | AlignLeft);

    lbl_DateTimeValue = new QLabel("", this);
    lbl_DateTimeValue -> setGeometry(90, 60, 180, 20);
    lbl_DateTimeValue -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbl_DateTimeValue -> setAlignment(AlignTop | AlignLeft);

    tv_Text = new QTextView(this);
    tv_Text -> setGeometry(12, 85, 258, 150);
}


/*
 * destructor of Kpopup
 */
Kpopup::~Kpopup() {
}


/*
 * method init
 */
void Kpopup::init() {
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(timerDone()));
}


/*
 * method initialize the toolbar
 */
void Kpopup::initToolbar() {
    toolbar = new KToolBar(this);

    toolbar -> insertButton(BarIcon("exit"), ID_EXIT, true, i18n("Quit"));
    toolbar -> insertSeparator();
    toolbar -> insertButton(BarIcon("filenew"), ID_NEW_POPUP, true, i18n("New"));
    toolbar -> insertButton(BarIcon("reload"), ID_ANSWER_POPUP, true, i18n("Answer"));
    toolbar -> insertButton(BarIcon("back"), ID_PREVIOUS_POPUP, false, i18n("Previous"));
    toolbar -> insertButton(BarIcon("forward"), ID_NEXT_POPUP, false, i18n("Next"));
    toolbar -> insertButton(BarIcon("remove"), ID_DELETE_POPUP, false, i18n("Delete"));
    toolbar -> insertSeparator();
    toolbar -> insertSeparator();
    toolbar -> insertButton(BarIcon("help"), ID_HELP, true, i18n("Help"));

    connect(toolbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));
}


/*
 * method initialisize the statusbar
 */
void Kpopup::initStatusbar() {
    statusbar = new KStatusBar(this);
    statusBar() -> insertItem("", ID_STATUS_TEXT, 1, true);
}


/*
 * method handles events
 */
void Kpopup::commandCallback(int id) {

    switch(id) {
        case ID_EXIT:
                kapp -> quit();
                break;
        case ID_NEW_POPUP:
                newPopup();
                break;
        case ID_ANSWER_POPUP:
                answerPopup();
                break;
        case ID_HELP:
                kapp -> invokeHelp("", "");
                break;
        case ID_PREVIOUS_POPUP:
                actual--;
                showPopup();
                break;
        case ID_NEXT_POPUP:
                actual++;
                showPopup();
                break;
        case ID_DELETE_POPUP:
                deletePopup();
                break;
    }
}


/*
 * method timerDone
 */
void Kpopup::timerDone() {
    char text[15];
    sprintf(text, "Popup %i/%i", actual, senderMap.count());
    setStatusText(text);
}


/*
 * method setStattusText
 */
void Kpopup::setStatusText(const char *text) {
    statusbar -> changeItem(text, ID_STATUS_TEXT);
}


/*
 * method newPopup
 */
void Kpopup::newPopup() {
    Make_Popup *newPopupView;

    newPopupView = new Make_Popup(this, "New Popup");
    newPopupView -> resize(280, 220);
    newPopupView -> setCaption(i18n("New Popup"));
    newPopupView -> cb_Receiver -> insertItem("NO HOST", -1);
    newPopupView -> readBrowseList();
    newPopupView -> cb_Receiver -> setCurrentItem(0);
    newPopupView -> exec();
}


/*
 * method answerPopup
 */
void Kpopup::answerPopup() {
    const char *sender = lbl_SenderValue -> text();
    if(strlen(sender) != 0) {
        Make_Popup *answerPopupView;

        answerPopupView = new Make_Popup(this, "Answer Popup");
        answerPopupView -> resize(280, 220);
        answerPopupView -> setCaption(i18n("Answer Popup"));
        answerPopupView -> cb_Receiver -> insertItem(sender, -1);
        answerPopupView -> readBrowseList();
        answerPopupView -> cb_Receiver -> setCurrentItem(0);
        answerPopupView -> exec();
    } else {
        Make_Popup *newPopupView;

        newPopupView = new Make_Popup(this, "Answer Popup");
        newPopupView -> resize(280, 220);
        newPopupView -> setCaption(i18n("New Popup"));
        newPopupView -> cb_Receiver -> insertItem("NO HOST", -1);
        newPopupView -> readBrowseList();
        newPopupView -> cb_Receiver -> setCurrentItem(0);
        newPopupView -> exec();
   }
}


/*
 * method signalNewMessage
 */
void Kpopup::signalNewMessage() {

#ifdef DEBUG
    fprintf(stderr, "signal received\n");
#endif

    actual = senderMap.count() + 1;
    senderMap.insert(actual, readSender());
    popupTextMap.insert(actual, readPopupText());
    currentTime = new QTime();
    *currentTime = currentTime -> currentTime();
    currentDate = new QDate();
    *currentDate = currentDate -> currentDate();
    timeMap.insert(actual, currentDate -> toString() + " " + currentTime -> toString());

    showPopup();
    kapp -> beep();
    showMaximized();
}


/*
 * method checked maps and set buttons in toolbar
 */
void Kpopup::checkMap() {
    int count = senderMap.count();

    if (count != 0) {
        toolBar() -> getButton(ID_DELETE_POPUP) -> setEnabled(true);
    } else {
        toolBar() -> getButton(ID_DELETE_POPUP) -> setEnabled(false);
    }

    if (count > 1 && actual > 1) {
        toolBar() -> getButton(ID_PREVIOUS_POPUP) -> setEnabled(true);
    } else {
        toolBar() -> getButton(ID_PREVIOUS_POPUP) -> setEnabled(false);
    }

    if (count > 1 && actual < count) {
        toolBar() -> getButton(ID_NEXT_POPUP) -> setEnabled(true);
    } else {
        toolBar() -> getButton(ID_NEXT_POPUP) -> setEnabled(false);
    }
}


/*
 * method displayed popup
 */
void Kpopup::showPopup() {

    if (!senderMap.isEmpty()) {
        lbl_SenderValue -> setText(senderMap[actual]);
        lbl_DateTimeValue -> setText(timeMap[actual]);
        tv_Text -> setText(popupTextMap[actual]);
    } else {
        lbl_SenderValue -> setText("");
        lbl_DateTimeValue -> setText("");
        tv_Text -> setText("");
    }

    checkMap();
    timerDone();
}


/*
 * method remove a popup from maps
 */
void Kpopup::deletePopup() {
    int count = senderMap.count();

    if (actual == count) {
        senderMap.remove(actual);
        timeMap.remove(actual);
        popupTextMap.remove(actual);
        actual--;
    } else {
        for (int i = actual; i <= count - 1; i++) {
            senderMap.insert(i, senderMap[i + 1]);
            senderMap.remove(i + 1);
            timeMap.insert(i, timeMap[i + 1]);
            timeMap.remove(i + 1);
            popupTextMap.insert(i, popupTextMap[i + 1]);
            popupTextMap.remove(i + 1);
        }
    }

    showPopup();
}

/*
 * hide event from KMainWindow
 */
void Kpopup::hideEvent(QHideEvent *e) {

    KMainWindow::hideEvent(e);
    tray -> show();
    hide();
}
