/***************************************************************************
                          make_popup.cpp  -  description
                          ------------------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctype.h>
#include <malloc.h>
#include <stdio.h>
#include <unistd.h>

#include <klocale.h>
#include <kmessagebox.h>

#include <qfile.h>

#include <make_popup.h>
#include <misc.h>

/*
 * contructor of Make_Popup
 */
Make_Popup::Make_Popup(QWidget *parent, const char *name) : KDialog(parent, name, TRUE) {
    hostname = (char *) malloc (50 * (sizeof(char)));
    readHostName();

    btn_Ok = new QPushButton(i18n("Ok"), this);
    btn_Ok -> setGeometry(25, 165, 60, 25);
    connect(btn_Ok, SIGNAL(clicked()), SLOT(sendPopup()));

    btn_Cancel = new QPushButton(i18n("Cancel"), this );
    btn_Cancel -> setGeometry(170, 165, 85, 25);
    connect(btn_Cancel, SIGNAL(clicked()), SLOT(reject()));

    lbl_Receiver = new QLabel(i18n("To:"), this);
    lbl_Receiver -> setGeometry(20, 9, 30, 20);

    cb_Receiver = new QComboBox(TRUE, this);
    cb_Receiver -> setGeometry(55, 8, 205, 22);

    lbl_Text = new QLabel(i18n("Text:"), this);
    lbl_Text -> setGeometry(20, 33, 98, 20);

    mle_Text = new QMultiLineEdit(this);
    mle_Text -> setGeometry(20, 57, 240, 100);

    setMinimumSize(280, 195);
    setMaximumSize(280, 195);
}


/*
 * destructor of Make_Popup
 */
Make_Popup::~Make_Popup() {
    free(hostname);
}


/*
 * method sendPopup
 */
void Make_Popup::sendPopup() {
    FILE *sendprocess;
    char *commandline;
    int linecount = 0;

    commandline = (char *) malloc (182 * (sizeof(char)));
    sprintf(commandline, "%s/smbclient -M %s -N -U %s > /dev/null", SMBPATH, (const char *)cb_Receiver -> currentText(), hostname);

    if ((sendprocess = popen(commandline, "w")) != 0) {
        while (linecount < mle_Text -> numLines()) {
            fprintf(sendprocess, "%s\n", (const char *)mle_Text -> textLine(linecount));
            linecount++;
        }
        if (pclose(sendprocess) == 0) {
            KMessageBox::information(this, i18n("Popup sent!"), i18n("Success"));
            reject();
        } else {
            KMessageBox::sorry(this, i18n("Popup not sent!"), i18n("Error"));
        }
    }

    free(commandline);
}


/*
 * method readHostName
 */
void Make_Popup::readHostName() {

    gethostname(hostname, 50);
    for(int i = 0; i < 50; i++) {
        if(hostname[i] == '.') {
            hostname[i] = '\x0';
            break;
        } else {
            hostname[i] = toupper(hostname[i]);
        }
    }
}


/*
 * method readBrowseList
 */
void Make_Popup::readBrowseList() {
    QFile *hostfile = new QFile("/tmp/kpopup.hostlist");
    char *line = (char *) malloc (201 * (sizeof(char)));
    char *host = (char *) malloc (22 * (sizeof(char)));
    int flag1 = 0, flag2 = 0;

    if (hostfile -> open(IO_ReadOnly)) {
        while (!(hostfile -> atEnd())) {
            hostfile -> readLine(line, 200);
            if ((strlen(line) == 1) && (flag1 == 1)) {
                flag2 = 1;
            }
            if ((flag1 == 1) && (flag2 == 0)) {
                if ((strlen(line) > 22) && (line[0] == '\t') && (strncmp(line, "	---------", 10) > 0)) {
                    line[0] = ' ';
                    line[22] = 0;
                    for (int i = 23; i >= 1; i--) {
                        host[i - 1] = 0;
                        if (line[i] == 32) {
                            host[i - 1] = 0;
                        } else {
                            host[i - 1] = line[i];
                        }
                    }
                    cb_Receiver -> insertItem(host, -1);
                }
            }
            if ((strncmp(line, "	Server               Comment", 24)) == 0) {
                flag1 = 1;
            }
        }
        free(line);
        free(host);
        hostfile -> close();
    }
}
