/***************************************************************************
 *   Copyright (C) 2000 by Torsten Henschel                                *
 *   thenschel@henschelsoft.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kpopup.h"

#include <stdio.h>
#include <stdlib.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>


static const char description[] = I18N_NOOP("WinPopup-Client for KDE");


static KCmdLineOptions options[] = {
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

/*
 * main
 */
int main(int argc, char **argv) {
    KAboutData about("kpopup", I18N_NOOP("KPopup"), VERSION, description,
                     KAboutData::License_GPL, "(c) 2000-2004 Torsten Henschel", 0, "http://www.henschelsoft.de", "thenschel@henschelsoft.de");
    about.addAuthor("Torsten Henschel", 0, "thenschel@henschelsoft.de" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();

    // check if KPopup is already started
    if (! KUniqueApplication::start()) {
       printf("KPopup is already running!\n");
       exit(0);
    }

    KUniqueApplication app;

    if (app.isRestored())
    {
        kdDebug() << "KPopup will be restored by session manager" << endl;
        
        RESTORE(KPopup);
    }
    else
    {
        kdDebug() << "KPopup not started by session manager" << endl;
        
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        KPopup *w = new KPopup();
        w -> setCaption("KPopup");
        app.setMainWidget(w);
        w->show();

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}
